/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.ConfigurationException;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.lookup.LookupResult;

public class LookupTableExtractor
extends Extractor {
    private static final String CONFIG_LUT_NAME = "lookup_table_name";
    private final LookupTableService.Function lookupTable;

    public LookupTableExtractor(MetricRegistry metricRegistry, LookupTableService lookupTableService, String id, String title, long order, Extractor.CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws Extractor.ReservedFieldException, ConfigurationException {
        super(metricRegistry, id, title, order, Extractor.Type.LOOKUP_TABLE, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
        String lookupTableName = (String)extractorConfig.get(CONFIG_LUT_NAME);
        if (Strings.isNullOrEmpty((String)lookupTableName)) {
            throw new ConfigurationException("Missing lookup table extractor configuration field: lookup_table_name");
        }
        if (!lookupTableService.hasTable(lookupTableName)) {
            throw new IllegalStateException("Configured lookup table <" + lookupTableName + "> doesn't exist");
        }
        this.lookupTable = lookupTableService.newBuilder().lookupTable(lookupTableName).build();
    }

    @Override
    @Nullable
    protected Extractor.Result[] run(String sourceFieldValue) {
        LookupResult result = this.lookupTable.lookup(sourceFieldValue);
        if (result == null || result.isEmpty()) {
            return null;
        }
        Object value = result.singleValue();
        if (value == null) {
            return null;
        }
        return new Extractor.Result[]{new Extractor.Result(value, this.targetField, -1, -1)};
    }
}

