/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

public class HttpHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final boolean enableCors;

    public HttpHandler(boolean enableCors) {
        this.enableCors = enableCors;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        Channel channel = ctx.channel();
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpVersion httpRequestVersion = request.protocolVersion();
        String origin = request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (HttpMethod.OPTIONS.equals((Object)request.method())) {
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.OK, origin);
            return;
        }
        if (!HttpMethod.POST.equals((Object)request.method())) {
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.METHOD_NOT_ALLOWED, origin);
            return;
        }
        boolean correctPath = "/gelf".equals(request.uri());
        if (correctPath && request instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)request;
            ByteBuf buffer = fullHttpRequest.content();
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.ACCEPTED, origin);
            ctx.fireChannelRead((Object)buffer);
        } else {
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.NOT_FOUND, origin);
        }
    }

    private void writeResponse(Channel channel, boolean keepAlive, HttpVersion httpRequestVersion, HttpResponseStatus status, String origin) {
        DefaultHttpResponse response = new DefaultHttpResponse(httpRequestVersion, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(keepAlive ? HttpHeaderValues.KEEP_ALIVE : HttpHeaderValues.CLOSE));
        if (this.enableCors && origin != null && !origin.isEmpty()) {
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)true);
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)"Authorization, Content-Type");
        }
        ChannelFuture channelFuture = channel.writeAndFlush((Object)response);
        if (!keepAlive) {
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

