/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.NettyTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAggregationHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTransport.class);
    private final CodecAggregator aggregator;
    private final Timer aggregationTimer;
    private final Meter invalidChunksMeter;

    public MessageAggregationHandler(CodecAggregator aggregator, MetricRegistry metricRegistry) {
        this.aggregator = aggregator;
        this.aggregationTimer = metricRegistry.timer("aggregationTime");
        this.invalidChunksMeter = metricRegistry.meter("invalidMessages");
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        CodecAggregator.Result result;
        try (Timer.Context ignored = this.aggregationTimer.time();){
            result = this.aggregator.addChunk(msg);
        }
        ByteBuf completeMessage = result.getMessage();
        if (completeMessage != null) {
            LOG.debug("Message aggregation completion, forwarding {}", (Object)completeMessage);
            ctx.fireChannelRead((Object)completeMessage);
        } else if (result.isValid()) {
            LOG.debug("More chunks necessary to complete this message");
        } else {
            this.invalidChunksMeter.mark();
            LOG.debug("Message chunk was not valid and discarded.");
        }
    }
}

