/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.transports.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KeyUtil.class);
    private static final Joiner JOINER = Joiner.on((String)",").skipNulls();
    private static final Pattern KEY_PATTERN = Pattern.compile("-{5}BEGIN (?:(RSA|DSA|EC)? )?(ENCRYPTED )?PRIVATE KEY-{5}\\r?\\n([A-Z0-9a-z+/\\r\\n]+={0,2})\\r?\\n-{5}END (?:(?:RSA|DSA|EC)? )?(?:ENCRYPTED )?PRIVATE KEY-{5}\\r?\\n$", 8);

    public static TrustManager[] initTrustStore(File tlsClientAuthCertFile) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, null);
        KeyUtil.loadCertificates(trustStore, tlsClientAuthCertFile, CertificateFactory.getInstance("X.509"));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Client authentication certificate file: {}", (Object)tlsClientAuthCertFile);
            LOG.debug("Aliases: {}", (Object)KeyUtil.join(trustStore.aliases()));
        }
        TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        instance.init(trustStore);
        return instance.getTrustManagers();
    }

    private static void loadCertificates(KeyStore trustStore, File certFile, CertificateFactory cf) throws CertificateException, KeyStoreException, IOException {
        if (certFile.isFile()) {
            Collection<? extends Certificate> certificates = KeyUtil.loadCertificates(certFile.toPath());
            int i = 0;
            for (Certificate certificate : certificates) {
                String alias = certFile.getAbsolutePath() + "_" + i;
                trustStore.setCertificateEntry(alias, certificate);
                ++i;
                LOG.debug("Added certificate with alias {} to trust store: {}", (Object)alias, (Object)certificate);
            }
        } else if (certFile.isDirectory()) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(certFile.toPath());){
                for (Path path : ds) {
                    KeyUtil.loadCertificates(trustStore, path.toFile(), cf);
                }
            }
        }
    }

    public static Collection<? extends Certificate> loadCertificates(Path certificatePath) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream inputStream = Files.newInputStream(certificatePath, new OpenOption[0]);){
            Collection<? extends Certificate> collection = cf.generateCertificates(inputStream);
            return collection;
        }
    }

    public static KeyManager[] initKeyStore(File tlsKeyFile, File tlsCertFile, String tlsKeyPassword) throws IOException, GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        Collection<? extends Certificate> certChain = KeyUtil.loadCertificates(tlsCertFile.toPath());
        PrivateKey privateKey = KeyUtil.loadPrivateKey(tlsKeyFile, tlsKeyPassword);
        char[] password = Strings.nullToEmpty((String)tlsKeyPassword).toCharArray();
        ks.setKeyEntry("key", privateKey, password, certChain.toArray(new Certificate[certChain.size()]));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Private key file: {}", (Object)tlsKeyFile);
            LOG.debug("Certificate file: {}", (Object)tlsCertFile);
            LOG.debug("Aliases: {}", (Object)KeyUtil.join(ks.aliases()));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, password);
        return kmf.getKeyManagers();
    }

    private static String join(Enumeration<String> aliases) {
        return JOINER.join((Iterator)Iterators.forEnumeration(aliases));
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    protected static PrivateKey loadPrivateKey(File file, String password) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 8[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PKCS8EncodedKeySpec createKeySpec(byte[] keyBytes, String password) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (Strings.isNullOrEmpty((String)password)) {
            return new PKCS8EncodedKeySpec(keyBytes);
        }
        EncryptedPrivateKeyInfo pkInfo = new EncryptedPrivateKeyInfo(keyBytes);
        SecretKeyFactory kf = SecretKeyFactory.getInstance(pkInfo.getAlgName());
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
        SecretKey secretKey = kf.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance(pkInfo.getAlgName());
        cipher.init(2, (Key)secretKey, pkInfo.getAlgParameters());
        return pkInfo.getKeySpec(cipher);
    }

    public static X509Certificate readCertificate(Path path) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        return PemX509Certificate.valueOf((byte[])bytes);
    }

    public static PrivateKey readPrivateKey(Path path) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        return PemPrivateKey.valueOf((byte[])bytes);
    }
}

