/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.PositiveOrZero;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.search.responses.FieldStatsResult;
import org.graylog2.rest.models.search.responses.HistogramResult;
import org.graylog2.rest.models.search.responses.TermsHistogramResult;
import org.graylog2.rest.models.search.responses.TermsResult;
import org.graylog2.rest.models.search.responses.TermsStatsResult;
import org.graylog2.rest.resources.search.SearchResource;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.graylog2.utilities.SearchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Search/Relative", description="Message search")
@Path(value="/search/universal/relative")
public class RelativeSearchResource
extends SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(RelativeSearchResource.class);

    @Inject
    public RelativeSearchResource(Searches searches, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor) {
        super(searches, clusterConfigService, decoratorProcessor);
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with relative timerange.", notes="Search for messages in a relative timerange, specified as seconds from now. Example: 300 means search from 5 minutes ago to now.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public SearchResponse searchRelative(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="range", value="Relative timeframe to search in. See method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=false) @QueryParam(value="fields") String fields, @ApiParam(name="sort", value="Sorting (field:asc / field:desc)", required=false) @QueryParam(value="sort") String sort, @ApiParam(name="decorate", value="Run decorators on search result", required=false) @QueryParam(value="decorate") @DefaultValue(value="true") boolean decorate) {
        this.checkSearchPermission(filter, "searches:relative");
        List<String> fieldList = this.parseOptionalFields(fields);
        Sorting sorting = this.buildSorting(sort);
        TimeRange timeRange = this.buildRelativeTimeRange(range);
        SearchesConfig searchesConfig = SearchesConfig.builder().query(query).filter(filter).fields(fieldList).range(timeRange).limit(limit).offset(offset).sorting(sorting).build();
        Optional<String> streamId = Searches.extractStreamId(filter);
        return this.buildSearchResponse(this.searches.search(searchesConfig), timeRange, decorate, streamId);
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with relative timerange.", notes="Search for messages in a relative timerange, specified as seconds from now. Example: 300 means search from 5 minutes ago to now.")
    @Produces(value={"text/csv"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    public ChunkedOutput<ScrollResult.ScrollChunk> searchRelativeChunked(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="range", value="Relative timeframe to search in. See method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=true) @QueryParam(value="fields") @NotEmpty String fields) {
        this.checkSearchPermission(filter, "searches:relative");
        List<String> fieldList = this.parseFields(fields);
        TimeRange timeRange = this.buildRelativeTimeRange(range);
        ScrollResult scroll = this.searches.scroll(query, timeRange, limit, offset, fieldList, filter);
        return this.buildChunkedOutput(scroll, limit);
    }

    @GET
    @Path(value="/export")
    @Timed
    @ApiOperation(value="Export message search with relative timerange.", notes="Search for messages in a relative timerange, specified as seconds from now. Example: 300 means search from 5 minutes ago to now.")
    @Produces(value={"text/csv"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    public Response exportSearchRelativeChunked(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="range", value="Relative timeframe to search in. See method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=true) @QueryParam(value="fields") @NotEmpty String fields) {
        this.checkSearchPermission(filter, "searches:relative");
        String filename = "graylog-search-result-relative-" + range + ".csv";
        return Response.ok(this.searchRelativeChunked(query, range, limit, offset, filter, fields)).header("Content-Disposition", (Object)("attachment; filename=" + filename)).build();
    }

    @GET
    @Path(value="/terms")
    @Timed
    @ApiOperation(value="Most common field terms of a query using a relative timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public TermsResult termsRelative(@ApiParam(name="field", value="Message field of to return terms of", required=true) @QueryParam(value="field") @NotEmpty String field, @ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="stacked_fields", value="Fields to stack", required=false) @QueryParam(value="stacked_fields") String stackedFieldsParam, @ApiParam(name="size", value="Maximum number of terms to return", required=false) @QueryParam(value="size") int size, @ApiParam(name="range", value="Relative timeframe to search in. See search method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="order", value="Sorting (field:asc / field:desc)", required=false) @QueryParam(value="order") String order) {
        this.checkSearchPermission(filter, "searches:relative");
        List<String> stackedFields = this.splitStackedFields(stackedFieldsParam);
        Sorting sortOrder = this.buildSorting(order);
        return this.buildTermsResult(this.searches.terms(field, stackedFields, size, query, filter, this.buildRelativeTimeRange(range), sortOrder.getDirection()));
    }

    @GET
    @Path(value="/terms-histogram")
    @Timed
    @ApiOperation(value="Most common field terms of a query over time using a relative timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public TermsHistogramResult termsHistogramRelative(@ApiParam(name="field", value="Message field of to return terms of", required=true) @QueryParam(value="field") @NotEmpty String field, @ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="stacked_fields", value="Fields to stack", required=false) @QueryParam(value="stacked_fields") String stackedFieldsParam, @ApiParam(name="size", value="Maximum number of terms to return", required=true) @QueryParam(value="size") @Min(value=1L) @Min(value=1L) int size, @ApiParam(name="range", value="Relative timeframe to search in. See search method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="interval", value="Histogram interval / bucket size. (year, quarter, month, week, day, hour or minute)", required=false) @QueryParam(value="interval") String interval, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="order", value="Sorting (field:asc / field:desc)", required=false) @QueryParam(value="order") String order) {
        this.checkSearchPermission(filter, "searches:relative");
        List<String> stackedFields = this.splitStackedFields(stackedFieldsParam);
        Sorting sortOrder = this.buildSorting(order);
        TimeRange timeRange = this.buildRelativeTimeRange(range);
        return SearchUtils.buildTermsHistogramResult(this.searches.termsHistogram(field, stackedFields, size, query, filter, timeRange, SearchUtils.buildInterval(interval, timeRange), sortOrder.getDirection()));
    }

    @GET
    @Path(value="/termsstats")
    @Timed
    @ApiOperation(value="Ordered field terms of a query computed on another field using a relative timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public TermsStatsResult termsStatsRelative(@ApiParam(name="key_field", value="Message field of to return terms of", required=true) @QueryParam(value="key_field") @NotEmpty String keyField, @ApiParam(name="value_field", value="Value field used for computation", required=true) @QueryParam(value="value_field") @NotEmpty String valueField, @ApiParam(name="order", value="What to order on (Allowed values: TERM, REVERSE_TERM, COUNT, REVERSE_COUNT, TOTAL, REVERSE_TOTAL, MIN, REVERSE_MIN, MAX, REVERSE_MAX, MEAN, REVERSE_MEAN)", required=true) @QueryParam(value="order") @NotEmpty String order, @ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="size", value="Maximum number of terms to return", required=false) @QueryParam(value="size") int size, @ApiParam(name="range", value="Relative timeframe to search in. See search method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter) {
        this.checkSearchPermission(filter, "searches:relative");
        return this.buildTermsStatsResult(this.searches.termsStats(keyField, valueField, Searches.TermsStatsOrder.valueOf(order.toUpperCase(Locale.ENGLISH)), size, query, filter, this.buildRelativeTimeRange(range)));
    }

    @GET
    @Path(value="/stats")
    @Timed
    @ApiOperation(value="Field statistics for a query using a relative timerange.", notes="Returns statistics like min/max or standard deviation of numeric fields over the whole query result set.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided."), @ApiResponse(code=400, message="Field is not of numeric type.")})
    @Produces(value={"application/json"})
    public FieldStatsResult statsRelative(@ApiParam(name="field", value="Message field of numeric type to return statistics for", required=true) @QueryParam(value="field") @NotEmpty String field, @ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="range", value="Relative timeframe to search in. See search method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter) {
        this.checkSearchPermission(filter, "searches:relative");
        return this.buildFieldStatsResult(this.fieldStats(field, query, filter, this.buildRelativeTimeRange(range)));
    }

    @GET
    @Path(value="/histogram")
    @Timed
    @ApiOperation(value="Datetime histogram of a query using a relative timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid interval provided."), @ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public HistogramResult histogramRelative(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="interval", value="Histogram interval / bucket size. (year, quarter, month, week, day, hour or minute)", required=true) @QueryParam(value="interval") @NotEmpty String interval, @ApiParam(name="range", value="Relative timeframe to search in. See search method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter) {
        this.checkSearchPermission(filter, "searches:relative");
        interval = interval.toUpperCase(Locale.ENGLISH);
        this.validateInterval(interval);
        return this.buildHistogramResult(this.searches.histogram(query, Searches.DateHistogramInterval.valueOf(interval), filter, this.buildRelativeTimeRange(range)));
    }

    @GET
    @Path(value="/fieldhistogram")
    @Timed
    @ApiOperation(value="Field value histogram of a query using a relative timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid interval provided."), @ApiResponse(code=400, message="Invalid timerange parameters provided."), @ApiResponse(code=400, message="Field is not of numeric type.")})
    @Produces(value={"application/json"})
    public HistogramResult fieldHistogramRelative(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="field", value="Field of whose values to get the histogram of", required=true) @QueryParam(value="field") @NotEmpty String field, @ApiParam(name="interval", value="Histogram interval / bucket size. (year, quarter, month, week, day, hour or minute)", required=true) @QueryParam(value="interval") @NotEmpty String interval, @ApiParam(name="range", value="Relative timeframe to search in. See search method description.", required=true) @QueryParam(value="range") @PositiveOrZero int range, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="cardinality", value="Calculate the cardinality of the field as well", required=false) @QueryParam(value="cardinality") boolean includeCardinality) {
        this.checkSearchPermission(filter, "searches:relative");
        interval = interval.toUpperCase(Locale.ENGLISH);
        this.validateInterval(interval);
        return this.buildHistogramResult(this.fieldHistogram(field, query, interval, filter, this.buildRelativeTimeRange(range), includeCardinality));
    }

    private TimeRange buildRelativeTimeRange(int range) {
        try {
            return this.restrictTimeRange(RelativeRange.create(range));
        }
        catch (InvalidRangeParametersException e) {
            LOG.warn("Invalid timerange parameters provided. Returning HTTP 400.");
            throw new BadRequestException((Throwable)e);
        }
    }
}

