/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.contentpacks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.entities.EntitiesWithConstraints;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.rest.models.system.contenpacks.responses.CatalogIndexResponse;
import org.graylog2.rest.models.system.contenpacks.responses.CatalogResolveRequest;
import org.graylog2.rest.models.system.contenpacks.responses.CatalogResolveResponse;

@RequiresAuthentication
@Api(value="System/Catalog", description="Entity Catalog")
@Path(value="/system/catalog")
@Produces(value={"application/json"})
public class CatalogResource {
    private final ContentPackService contentPackService;

    @Inject
    public CatalogResource(ContentPackService contentPackService) {
        this.contentPackService = contentPackService;
    }

    @GET
    @Timed
    @ApiOperation(value="List available entities in this Graylog cluster")
    @RequiresPermissions(value={"catalog:list"})
    public CatalogIndexResponse showEntityIndex() {
        Set<EntityExcerpt> entities = this.contentPackService.listAllEntityExcerpts();
        return CatalogIndexResponse.create(entities);
    }

    @POST
    @Timed
    @ApiOperation(value="Resolve dependencies of entities and return their configuration")
    @RequiresPermissions(value={"catalog:resolve"})
    @NoAuditEvent(value="this is not changing any data")
    public CatalogResolveResponse resolveEntities(@ApiParam(name="JSON body", required=true) @Valid @NotNull CatalogResolveRequest request) {
        ImmutableSet<EntityDescriptor> requestedEntities = request.entities();
        Set<EntityDescriptor> resolvedEntities = this.contentPackService.resolveEntities((Collection<EntityDescriptor>)requestedEntities);
        EntitiesWithConstraints entitiesWithConstraints = this.contentPackService.collectEntities(resolvedEntities);
        return CatalogResolveResponse.create(entitiesWithConstraints.constraints(), entitiesWithConstraints.entities());
    }
}

