/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;

public class EntityDescriptorIds {
    private final ImmutableMap<EntityDescriptor, String> descriptorIds;

    public static EntityDescriptorIds empty() {
        return new EntityDescriptorIds((ImmutableMap<EntityDescriptor, String>)ImmutableMap.of());
    }

    public static EntityDescriptorIds of(EntityDescriptor ... entityDescriptors) {
        return EntityDescriptorIds.of(Arrays.asList(entityDescriptors));
    }

    public static EntityDescriptorIds of(Collection<EntityDescriptor> entityDescriptors) {
        ImmutableMap descriptorIds = (ImmutableMap)entityDescriptors.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), d -> UUID.randomUUID().toString()));
        return new EntityDescriptorIds((ImmutableMap<EntityDescriptor, String>)descriptorIds);
    }

    private EntityDescriptorIds(ImmutableMap<EntityDescriptor, String> descriptorIds) {
        this.descriptorIds = descriptorIds;
    }

    public Optional<String> get(EntityDescriptor descriptor) {
        return Optional.ofNullable((String)this.descriptorIds.get((Object)descriptor));
    }

    public Optional<String> get(String id, ModelType type) {
        return Optional.ofNullable((String)this.descriptorIds.get((Object)EntityDescriptor.create(id, type)));
    }

    public String getOrThrow(EntityDescriptor descriptor) {
        return this.get(descriptor).orElseThrow(() -> new ContentPackException("Couldn't find entity " + descriptor.toString()));
    }

    public String getOrThrow(String id, ModelType type) {
        return this.get(id, type).orElseThrow(() -> new ContentPackException("Couldn't find entity " + id + "/" + type));
    }
}

