/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.exceptions.DivergingEntityConfigurationException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.SidecarCollectorEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarCollectorFacade
implements EntityFacade<Collector> {
    private static final Logger LOG = LoggerFactory.getLogger(SidecarCollectorFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.SIDECAR_COLLECTOR_V1;
    private final ObjectMapper objectMapper;
    private final CollectorService collectorService;

    @Inject
    public SidecarCollectorFacade(ObjectMapper objectMapper, CollectorService collectorService) {
        this.objectMapper = objectMapper;
        this.collectorService = collectorService;
    }

    @VisibleForTesting
    Entity exportNativeEntity(Collector collector, EntityDescriptorIds entityDescriptorIds) {
        SidecarCollectorEntity collectorEntity = SidecarCollectorEntity.create(ValueReference.of(collector.name()), ValueReference.of(collector.serviceType()), ValueReference.of(collector.nodeOperatingSystem()), ValueReference.of(collector.executablePath()), ValueReference.of(collector.executeParameters()), ValueReference.of(collector.validationParameters()), ValueReference.of(collector.defaultTemplate()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)collectorEntity, JsonNode.class);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(collector.id(), ModelTypes.SIDECAR_COLLECTOR_V1)))).type(TYPE_V1)).data(data).build();
    }

    @Override
    public NativeEntity<Collector> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<Collector> decode(EntityV1 entity, Map<String, ValueReference> parameters) {
        SidecarCollectorEntity collectorEntity = (SidecarCollectorEntity)this.objectMapper.convertValue((Object)entity.data(), SidecarCollectorEntity.class);
        Collector collector = Collector.builder().name(collectorEntity.name().asString(parameters)).serviceType(collectorEntity.serviceType().asString(parameters)).nodeOperatingSystem(collectorEntity.nodeOperatingSystem().asString(parameters)).executablePath(collectorEntity.executablePath().asString(parameters)).executeParameters(collectorEntity.executeParameters().asString(parameters)).validationParameters(collectorEntity.validationParameters().asString(parameters)).defaultTemplate(collectorEntity.defaultTemplate().asString(parameters)).build();
        Collector savedCollector = this.collectorService.save(collector);
        return NativeEntity.create(entity.id(), savedCollector.id(), TYPE_V1, collector.name(), savedCollector);
    }

    @Override
    public Optional<NativeEntity<Collector>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Optional<NativeEntity<Collector>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        SidecarCollectorEntity collectorEntity = (SidecarCollectorEntity)this.objectMapper.convertValue((Object)entity.data(), SidecarCollectorEntity.class);
        String name = collectorEntity.name().asString(parameters);
        String serviceType = collectorEntity.serviceType().asString(parameters);
        Optional<Collector> existingCollector = Optional.ofNullable(this.collectorService.findByName(name));
        existingCollector.ifPresent(collector -> this.compareCollectors(name, serviceType, (Collector)collector));
        return existingCollector.map(collector -> NativeEntity.create(entity.id(), collector.id(), TYPE_V1, collector.name(), collector));
    }

    private void compareCollectors(String name, String serviceType, Collector existingCollector) {
        if (!name.equals(existingCollector.name()) || !serviceType.equals(existingCollector.serviceType())) {
            throw new DivergingEntityConfigurationException("Expected service type for Collector with name \"" + name + "\": <" + serviceType + ">; actual service type: <" + existingCollector.serviceType() + ">");
        }
    }

    @Override
    public Optional<NativeEntity<Collector>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        return this.collectorService.get(nativeEntityDescriptor.id().id()).map(entity -> NativeEntity.create(nativeEntityDescriptor, entity));
    }

    @Override
    public void delete(Collector nativeEntity) {
        this.collectorService.delete(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(Collector collector) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(collector.id()))).type(TYPE_V1)).title(collector.name()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.collectorService.all().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        Collector collector = this.collectorService.find(modelId.id());
        if (Objects.isNull(collector)) {
            LOG.debug("Couldn't find collector {}", (Object)entityDescriptor);
            return Optional.empty();
        }
        return Optional.of(this.exportNativeEntity(collector, entityDescriptorIds));
    }
}

