/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities.references;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog2.contentpacks.model.entities.references.Reference;
import org.graylog2.contentpacks.model.entities.references.ReferenceList;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.contentpacks.model.entities.references.ValueType;

public final class ReferenceMapUtils {
    public static ReferenceMap toReferenceMap(Map<String, Object> m) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                List childList = (List)value;
                mapBuilder.put((Object)entry.getKey(), (Object)ReferenceMapUtils.toReferenceList(childList));
            }
            if (value instanceof Map) {
                Map childMap = (Map)value;
                mapBuilder.put((Object)entry.getKey(), (Object)ReferenceMapUtils.toReferenceMap(childMap));
                continue;
            }
            ValueReference valueReference = ValueReference.of(value);
            if (valueReference == null) continue;
            mapBuilder.put((Object)entry.getKey(), (Object)valueReference);
        }
        return new ReferenceMap((Map<String, Reference>)mapBuilder.build());
    }

    private static ReferenceList toReferenceList(Collection<Object> list) {
        return list.stream().map(ValueReference::of).filter(Objects::nonNull).collect(Collectors.toCollection(ReferenceList::new));
    }

    public static Map<String, Object> toValueMap(ReferenceMap m, Map<String, ValueReference> parameters) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : m.entrySet()) {
            Object value = ReferenceMapUtils.valueOf((Reference)entry.getValue(), parameters);
            if (value == null) continue;
            mapBuilder.put((Object)((String)entry.getKey()), value);
        }
        return mapBuilder.build();
    }

    @Nullable
    private static Object valueOf(Reference value, Map<String, ValueReference> parameters) {
        if (value instanceof ValueReference) {
            ValueReference valueReference = (ValueReference)value;
            return ReferenceMapUtils.valueOf(valueReference, parameters);
        }
        if (value instanceof ReferenceList) {
            ReferenceList collection = (ReferenceList)value;
            return ReferenceMapUtils.toValueList(collection, parameters);
        }
        if (value instanceof ReferenceMap) {
            ReferenceMap map = (ReferenceMap)value;
            return ReferenceMapUtils.toValueMap(map, parameters);
        }
        return null;
    }

    @Nullable
    private static Object valueOf(ValueReference valueReference, Map<String, ValueReference> parameters) {
        switch (valueReference.valueType()) {
            case BOOLEAN: {
                return valueReference.asBoolean(parameters);
            }
            case DOUBLE: {
                return valueReference.asDouble(parameters);
            }
            case FLOAT: {
                return valueReference.asFloat(parameters);
            }
            case INTEGER: {
                return valueReference.asInteger(parameters);
            }
            case LONG: {
                return valueReference.asLong(parameters);
            }
            case STRING: {
                return valueReference.asString(parameters);
            }
            case PARAMETER: {
                return ReferenceMapUtils.resolveParameterReference(valueReference, parameters);
            }
        }
        return null;
    }

    @Nullable
    private static Object resolveParameterReference(ValueReference valueReference, Map<String, ValueReference> parameters) {
        Object parameterName = valueReference.value();
        if (parameterName instanceof String) {
            ValueReference resolvedParameter = parameters.get(parameterName);
            if (resolvedParameter == null) {
                throw new IllegalArgumentException("Missing parameter " + parameterName);
            }
            if (resolvedParameter.valueType() == ValueType.PARAMETER) {
                throw new IllegalArgumentException("Circular parameter " + parameterName);
            }
            return ReferenceMapUtils.valueOf(resolvedParameter, parameters);
        }
        return null;
    }

    private static List<Object> toValueList(ReferenceList list, Map<String, ValueReference> parameters) {
        return list.stream().map(valueReference -> ReferenceMapUtils.valueOf(valueReference, parameters)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

