/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.indexer.indexset.DefaultIndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.events.IndexSetCreatedEvent;
import org.graylog2.indexer.indexset.events.IndexSetDeletedEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.streams.StreamService;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class MongoIndexSetService
implements IndexSetService {
    private static final String COLLECTION_NAME = "index_sets";
    private final JacksonDBCollection<IndexSetConfig, ObjectId> collection;
    private final ClusterConfigService clusterConfigService;
    private final ClusterEventBus clusterEventBus;
    private final StreamService streamService;

    @Inject
    public MongoIndexSetService(MongoConnection mongoConnection, MongoJackObjectMapperProvider objectMapperProvider, StreamService streamService, ClusterConfigService clusterConfigService, ClusterEventBus clusterEventBus) {
        this((JacksonDBCollection<IndexSetConfig, ObjectId>)JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), IndexSetConfig.class, ObjectId.class, (ObjectMapper)objectMapperProvider.get()), streamService, clusterConfigService, clusterEventBus);
    }

    @VisibleForTesting
    protected MongoIndexSetService(JacksonDBCollection<IndexSetConfig, ObjectId> collection, StreamService streamService, ClusterConfigService clusterConfigService, ClusterEventBus clusterEventBus) {
        this.collection = Objects.requireNonNull(collection);
        this.streamService = streamService;
        this.clusterConfigService = clusterConfigService;
        this.clusterEventBus = Objects.requireNonNull(clusterEventBus);
        this.collection.getDbCollection().createIndex((DBObject)DBSort.asc((String)"index_prefix"), null, true);
        this.collection.getDbCollection().createIndex((DBObject)DBSort.desc((String)"creation_date"));
    }

    @Override
    public Optional<IndexSetConfig> get(String id) {
        return this.get(new ObjectId(id));
    }

    @Override
    public Optional<IndexSetConfig> get(ObjectId id) {
        DBQuery.Query query = DBQuery.is((String)"_id", (Object)id);
        IndexSetConfig indexSetConfig = (IndexSetConfig)this.collection.findOne(query);
        return Optional.ofNullable(indexSetConfig);
    }

    @Override
    public IndexSetConfig getDefault() {
        DefaultIndexSetConfig defaultIndexSetConfig = this.clusterConfigService.get(DefaultIndexSetConfig.class);
        Preconditions.checkState((defaultIndexSetConfig != null ? 1 : 0) != 0, (Object)"No default index set configured. This is a bug!");
        String indexSetId = defaultIndexSetConfig.defaultIndexSetId();
        return this.get(indexSetId).orElseThrow(() -> new IllegalStateException("Couldn't find default index set <" + indexSetId + ">. This is a bug!"));
    }

    @Override
    public Optional<IndexSetConfig> findOne(DBQuery.Query query) {
        return Optional.ofNullable((IndexSetConfig)this.collection.findOne(query));
    }

    @Override
    public List<IndexSetConfig> findAll() {
        return ImmutableList.copyOf((Iterator)this.collection.find().sort((DBObject)DBSort.asc((String)"title")));
    }

    @Override
    public List<IndexSetConfig> findPaginated(Set<String> indexSetIds, int limit, int skip) {
        List<DBQuery.Query> idQuery = indexSetIds.stream().map(id -> DBQuery.is((String)"_id", (Object)id)).collect(Collectors.toList());
        DBQuery.Query query = DBQuery.or((DBQuery.Query[])idQuery.toArray(new DBQuery.Query[0]));
        return ImmutableList.copyOf((Collection)this.collection.find(query).sort((DBObject)DBSort.asc((String)"title")).skip(skip).limit(limit).toArray());
    }

    @Override
    public IndexSetConfig save(IndexSetConfig indexSetConfig) {
        WriteResult writeResult = this.collection.save((Object)indexSetConfig);
        IndexSetConfig savedObject = (IndexSetConfig)writeResult.getSavedObject();
        IndexSetCreatedEvent createdEvent = IndexSetCreatedEvent.create(savedObject);
        this.clusterEventBus.post(createdEvent);
        return savedObject;
    }

    @Override
    public int delete(String id) {
        return this.delete(new ObjectId(id));
    }

    @Override
    public int delete(ObjectId id) {
        if (!this.isDeletable(id)) {
            return 0;
        }
        DBQuery.Query query = DBQuery.is((String)"_id", (Object)id);
        WriteResult writeResult = this.collection.remove(query);
        int removedEntries = writeResult.getN();
        if (removedEntries > 0) {
            IndexSetDeletedEvent deletedEvent = IndexSetDeletedEvent.create(id.toHexString());
            this.clusterEventBus.post(deletedEvent);
        }
        return removedEntries;
    }

    private boolean isDeletable(ObjectId id) {
        return this.streamService.loadAllWithIndexSet(id.toHexString()).isEmpty();
    }
}

