/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.messages;

import com.codahale.metrics.annotation.Timed;
import com.eaio.uuid.UUID;
import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.messages.DocumentNotFoundException;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.inputs.codecs.CodecFactory;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.rest.models.messages.requests.MessageParseRequest;
import org.graylog2.rest.models.messages.responses.MessageTokens;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Messages", description="Single messages")
@Produces(value={"application/json"})
@Path(value="/messages")
public class MessageResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(MessageResource.class);
    private final Messages messages;
    private final CodecFactory codecFactory;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public MessageResource(Messages messages, CodecFactory codecFactory, IndexSetRegistry indexSetRegistry) {
        this.messages = Objects.requireNonNull(messages);
        this.codecFactory = Objects.requireNonNull(codecFactory);
        this.indexSetRegistry = Objects.requireNonNull(indexSetRegistry);
    }

    @GET
    @Path(value="/{index}/{messageId}")
    @Timed
    @ApiOperation(value="Get a single message.")
    @ApiResponses(value={@ApiResponse(code=404, message="Specified index does not exist."), @ApiResponse(code=404, message="Message does not exist.")})
    public ResultMessage search(@ApiParam(name="index", value="The index this message is stored in.", required=true) @PathParam(value="index") String index, @ApiParam(name="messageId", required=true) @PathParam(value="messageId") String messageId) throws IOException {
        this.checkPermission("messages:read", messageId);
        try {
            ResultMessage resultMessage = this.messages.get(messageId, index);
            Message message = resultMessage.getMessage();
            this.checkMessageReadPermission(message);
            return resultMessage;
        }
        catch (DocumentNotFoundException e) {
            String msg = "Message " + messageId + " does not exist in index " + index;
            LOG.error(msg, (Throwable)e);
            throw new NotFoundException(msg, (Throwable)e);
        }
    }

    private void checkMessageReadPermission(Message message) {
        if (this.isPermitted("streams:read", "*")) {
            return;
        }
        boolean permitted = false;
        for (String streamId : message.getStreamIds()) {
            if (!this.isPermitted("streams:read", streamId)) continue;
            permitted = true;
            break;
        }
        if (!permitted) {
            throw new ForbiddenException("Not authorized to access message " + message.getId());
        }
    }

    @POST
    @Path(value="/parse")
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Parse a raw message")
    @ApiResponses(value={@ApiResponse(code=404, message="Specified codec does not exist."), @ApiResponse(code=400, message="Could not decode message.")})
    @NoAuditEvent(value="only used to parse a test message")
    public ResultMessage parse(@ApiParam(name="JSON body", required=true) MessageParseRequest request) {
        Codec codec;
        try {
            Configuration configuration = new Configuration(request.configuration());
            codec = this.codecFactory.create(request.codec(), configuration);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException((Throwable)e);
        }
        ResolvableInetSocketAddress remoteAddress = ResolvableInetSocketAddress.wrap(new InetSocketAddress(request.remoteAddress(), 1234));
        RawMessage rawMessage = new RawMessage(0L, new UUID(), Tools.nowUTC(), remoteAddress, request.message().getBytes(StandardCharsets.UTF_8));
        Message message = this.decodeMessage(codec, remoteAddress, rawMessage);
        return ResultMessage.createFromMessage(message);
    }

    private Message decodeMessage(Codec codec, ResolvableInetSocketAddress remoteAddress, RawMessage rawMessage) {
        Configuration configuration;
        Message message;
        try {
            message = codec.decode(rawMessage);
        }
        catch (Exception e) {
            throw new BadRequestException("Could not decode message");
        }
        if (message == null) {
            throw new BadRequestException("Could not decode message");
        }
        if (Strings.isNullOrEmpty((String)message.getSource())) {
            String address = InetAddresses.toAddrString((InetAddress)remoteAddress.getAddress());
            message.setSource(address);
        }
        if ((configuration = codec.getConfiguration()).stringIsSet("override_source")) {
            message.setSource(configuration.getString("override_source"));
        }
        return message;
    }

    @GET
    @Path(value="/{index}/analyze")
    @Timed
    @ApiOperation(value="Analyze a message string", notes="Returns what tokens/terms a message string (message or full_message) is split to.")
    @RequiresPermissions(value={"messages:analyze"})
    @ApiResponses(value={@ApiResponse(code=404, message="Specified index does not exist.")})
    public MessageTokens analyze(@ApiParam(name="index", value="The index the message containing the string is stored in.", required=true) @PathParam(value="index") String index, @ApiParam(name="analyzer", value="The analyzer to use.") @QueryParam(value="analyzer") @Nullable String analyzer, @ApiParam(name="string", value="The string to analyze.", required=true) @QueryParam(value="string") @NotEmpty String string) throws IOException {
        String indexAnalyzer = this.indexSetRegistry.getForIndex(index).map(indexSet -> indexSet.getConfig().indexAnalyzer()).orElse("standard");
        String messageAnalyzer = analyzer == null ? indexAnalyzer : analyzer;
        return MessageTokens.create(this.messages.analyze(string, index, messageAnalyzer));
    }
}

