/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.facade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.events.contentpack.entities.EventDefinitionEntity;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventDefinitionHandler;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.PluginMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDefinitionFacade
implements EntityFacade<EventDefinitionDto> {
    private static final Logger LOG = LoggerFactory.getLogger(EventDefinitionFacade.class);
    private final ObjectMapper objectMapper;
    private final EventDefinitionHandler eventDefinitionHandler;
    private final DBEventDefinitionService eventDefinitionService;
    private final Set<PluginMetaData> pluginMetaData;

    @Inject
    public EventDefinitionFacade(ObjectMapper objectMapper, EventDefinitionHandler eventDefinitionHandler, Set<PluginMetaData> pluginMetaData, DBEventDefinitionService eventDefinitionService) {
        this.objectMapper = objectMapper;
        this.pluginMetaData = pluginMetaData;
        this.eventDefinitionHandler = eventDefinitionHandler;
        this.eventDefinitionService = eventDefinitionService;
    }

    @VisibleForTesting
    private Entity exportNativeEntity(EventDefinitionDto eventDefinition, EntityDescriptorIds entityDescriptorIds) {
        EventDefinitionEntity entity = eventDefinition.toContentPackEntity(entityDescriptorIds);
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)entity, JsonNode.class);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(eventDefinition.id(), ModelTypes.EVENT_DEFINITION_V1)))).type(ModelTypes.EVENT_DEFINITION_V1)).constraints(this.versionConstraints(eventDefinition)).data(data).build();
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        Optional eventDefinition = this.eventDefinitionService.get(modelId.id());
        if (!eventDefinition.isPresent()) {
            LOG.debug("Couldn't find event definition {}", (Object)entityDescriptor);
            return Optional.empty();
        }
        return Optional.of(this.exportNativeEntity((EventDefinitionDto)eventDefinition.get(), entityDescriptorIds));
    }

    private ImmutableSet<Constraint> versionConstraints(EventDefinitionDto eventDefinitionDto) {
        String packageName = eventDefinitionDto.config().getContentPackPluginPackage();
        return (ImmutableSet)this.pluginMetaData.stream().filter(metaData -> packageName.equals(metaData.getClass().getCanonicalName())).map(PluginVersionConstraint::of).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public NativeEntity<EventDefinitionDto> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, nativeEntities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<EventDefinitionDto> decode(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        EventDefinitionEntity eventDefinitionEntity = (EventDefinitionEntity)this.objectMapper.convertValue((Object)entity.data(), EventDefinitionEntity.class);
        Object eventDefinition = eventDefinitionEntity.toNativeEntity((Map)parameters, (Map)nativeEntities);
        EventDefinitionDto savedDto = this.eventDefinitionHandler.create((EventDefinitionDto)eventDefinition);
        return NativeEntity.create(entity.id(), savedDto.id(), ModelTypes.EVENT_DEFINITION_V1, savedDto.title(), savedDto);
    }

    @Override
    public Optional<NativeEntity<EventDefinitionDto>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        Optional eventDefinition = this.eventDefinitionService.get(nativeEntityDescriptor.id().id());
        return eventDefinition.map(eventDefinitionDto -> NativeEntity.create(nativeEntityDescriptor, eventDefinitionDto));
    }

    @Override
    public void delete(EventDefinitionDto nativeEntity) {
        this.eventDefinitionHandler.delete(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(EventDefinitionDto nativeEntity) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(nativeEntity.id()))).type(ModelTypes.EVENT_DEFINITION_V1)).title(nativeEntity.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.eventDefinitionService.streamAll().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        Optional eventDefinition = this.eventDefinitionService.get(modelId.id());
        if (!eventDefinition.isPresent()) {
            LOG.debug("Couldn't find event definition {}", (Object)entityDescriptor);
        }
        ((EventDefinitionDto)eventDefinition.get()).resolveNativeEntity(entityDescriptor, (MutableGraph<EntityDescriptor>)mutableGraph);
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveForInstallationV1((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Graph<Entity> resolveForInstallationV1(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph graph = GraphBuilder.directed().build();
        graph.addNode((Object)entity);
        EventDefinitionEntity eventDefinition = (EventDefinitionEntity)this.objectMapper.convertValue((Object)entity.data(), EventDefinitionEntity.class);
        eventDefinition.resolveForInstallation(entity, parameters, entities, (MutableGraph<Entity>)graph);
        return ImmutableGraph.copyOf((Graph)graph);
    }
}

