/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationStatus;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PaginatedDbService;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;

public class DBNotificationGracePeriodService
extends PaginatedDbService<EventNotificationStatus> {
    private static final String NOTIFICATION_STATUS_COLLECTION_NAME = "event_notification_status";
    private JobSchedulerClock clock;

    @Inject
    public DBNotificationGracePeriodService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, JobSchedulerClock clock) {
        super(mongoConnection, mapper, EventNotificationStatus.class, NOTIFICATION_STATUS_COLLECTION_NAME);
        this.clock = clock;
    }

    public boolean inGracePeriod(EventDto event, String notificationId, long grace) throws NotFoundException {
        EventNotificationStatus status = this.getNotificationStatus(notificationId, event.eventDefinitionId(), event.key()).orElseThrow(NotFoundException::new);
        Optional<DateTime> lastNotification = status.notifiedAt();
        return lastNotification.map(dateTime -> dateTime.isAfter((ReadableInstant)event.eventTimestamp().minus(grace))).orElse(false);
    }

    public List<EventNotificationStatus> getAllStatuses() {
        ArrayList<EventNotificationStatus> result = new ArrayList<EventNotificationStatus>();
        try (DBCursor eventNotificationStatuses = this.db.find();){
            for (EventNotificationStatus status : eventNotificationStatuses) {
                result.add(status);
            }
        }
        return result;
    }

    public int deleteStatus(String statusId) {
        ObjectId id = new ObjectId(statusId);
        return this.db.removeById((Object)id).getN();
    }

    private Optional<EventNotificationStatus> getNotificationStatus(String notificationId, String definitionId, String key) {
        if (notificationId == null || definitionId == null || key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((EventNotificationStatus)this.db.findOne(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"notification_id", (Object)notificationId), DBQuery.is((String)"event_definition_id", (Object)definitionId), DBQuery.is((String)"event_key", (Object)key)})));
    }

    public void updateTriggerStatus(String notificationId, EventDto eventDto, long grace) {
        this.updateStatus(eventDto, notificationId, "triggered", grace);
    }

    public void updateNotifiedStatus(String notificationId, EventDto eventDto, long grace) {
        this.updateStatus(eventDto, notificationId, "notified", grace);
    }

    private void updateStatus(EventDto eventDto, String notificationId, String type, long grace) {
        Optional<EventNotificationStatus> optionalStatus = this.getNotificationStatus(notificationId, eventDto.eventDefinitionId(), eventDto.key());
        EventNotificationStatus.Builder statusBuilder = optionalStatus.isPresent() ? optionalStatus.get().toBuilder() : EventNotificationStatus.Builder.create();
        switch (type) {
            case "triggered": {
                statusBuilder.triggeredAt(Optional.of(this.clock.nowUTC()));
                break;
            }
            case "notified": {
                statusBuilder.notifiedAt(Optional.of(eventDto.eventTimestamp()));
            }
        }
        EventNotificationStatus status = statusBuilder.notificationId(notificationId).eventKey(eventDto.key()).gracePeriodMs(grace).eventDefinitionId(eventDto.eventDefinitionId()).build();
        this.db.save((Object)status);
    }
}

