/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.rest;

import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventDefinitionHandler;
import org.graylog.events.processor.EventProcessorEngine;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.processor.EventProcessorParameters;
import org.graylog.events.processor.EventProcessorParametersWithTimerange;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Events/Definitions", description="Event definition management")
@Path(value="/events/definitions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class EventDefinitionsResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(EventDefinitionsResource.class);
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("id")).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    private final DBEventDefinitionService dbService;
    private final EventDefinitionHandler eventDefinitionHandler;
    private final EventProcessorEngine engine;
    private final SearchQueryParser searchQueryParser;

    @Inject
    public EventDefinitionsResource(DBEventDefinitionService dbService, EventDefinitionHandler eventDefinitionHandler, EventProcessorEngine engine) {
        this.dbService = dbService;
        this.eventDefinitionHandler = eventDefinitionHandler;
        this.engine = engine;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @ApiOperation(value="List event definitions")
    public PaginatedResponse<EventDefinitionDto> list(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        PaginatedList<EventDefinitionDto> result = this.dbService.searchPaginated(searchQuery, event -> this.isPermitted("eventdefinitions:read", event.id()), "title", page, perPage);
        return PaginatedResponse.create("event_definitions", result, query);
    }

    @GET
    @Path(value="{definitionId}")
    @ApiOperation(value="Get an event definition")
    public EventDefinitionDto get(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId) {
        this.checkPermission("eventdefinitions:read", definitionId);
        return (EventDefinitionDto)this.dbService.get(definitionId).orElseThrow(() -> new NotFoundException("Event definition <" + definitionId + "> doesn't exist"));
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new event definition")
    @AuditEvent(type="events:definition:create")
    @RequiresPermissions(value={"eventdefinitions:create"})
    public Response create(@ApiParam(name="JSON Body") EventDefinitionDto dto) {
        this.checkEventDefinitionPermissions(dto, "create");
        ValidationResult result = dto.validate();
        if (result.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
        }
        return Response.ok().entity((Object)this.eventDefinitionHandler.create(dto)).build();
    }

    @PUT
    @Path(value="{definitionId}")
    @ApiOperation(value="Update existing event definition")
    @AuditEvent(type="events:definition:update")
    public Response update(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @ApiParam(name="JSON Body") EventDefinitionDto dto) {
        this.checkPermission("eventdefinitions:edit", definitionId);
        this.checkEventDefinitionPermissions(dto, "update");
        this.dbService.get(definitionId).orElseThrow(() -> new NotFoundException("Event definition <" + definitionId + "> doesn't exist"));
        ValidationResult result = dto.validate();
        if (!definitionId.equals(dto.id())) {
            result.addError("id", "Event definition IDs don't match");
        }
        if (result.failed()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
        }
        return Response.ok().entity((Object)this.eventDefinitionHandler.update(dto)).build();
    }

    @DELETE
    @Path(value="{definitionId}")
    @ApiOperation(value="Delete event definition")
    @AuditEvent(type="events:definition:delete")
    public void delete(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId) {
        this.checkPermission("eventdefinitions:delete", definitionId);
        this.eventDefinitionHandler.delete(definitionId);
    }

    @POST
    @ApiOperation(value="Execute event definition")
    @Path(value="{definitionId}/execute")
    @AuditEvent(type="events:definition:execute")
    public void execute(@ApiParam(name="definitionId") @PathParam(value="definitionId") @NotBlank String definitionId, @ApiParam(name="parameters", required=true) @NotNull EventProcessorParameters parameters) {
        this.checkPermission("eventdefinitions:execute", definitionId);
        if (parameters instanceof EventProcessorParametersWithTimerange.FallbackParameters) {
            throw new BadRequestException("Unknown parameters type");
        }
        try {
            this.engine.execute(definitionId, parameters);
        }
        catch (EventProcessorException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @POST
    @Path(value="/validate")
    @NoAuditEvent(value="Validation only")
    @ApiOperation(value="Validate an event definition")
    @RequiresPermissions(value={"eventdefinitions:create"})
    public ValidationResult validate(@ApiParam(name="JSON body", required=true) @Valid @NotNull EventDefinitionDto toValidate) {
        return toValidate.config().validate();
    }

    private void checkEventDefinitionPermissions(EventDefinitionDto dto, String action) {
        Set missingPermissions = dto.requiredPermissions().stream().filter(permission -> !this.isPermitted((String)permission)).collect(Collectors.toSet());
        if (!missingPermissions.isEmpty()) {
            LOG.info("Not authorized to {} event definition. User <{}> is missing permissions: {}", new Object[]{action, this.getSubject().getPrincipal(), missingPermissions});
            throw new ForbiddenException("Not authorized");
        }
    }
}

