/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.net.InetAddresses;
import com.google.inject.assistedinject.Assisted;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.map.config.DatabaseType;
import org.graylog.plugins.map.geoip.;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.plugin.utilities.FileInfo;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxmindDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MaxmindDataAdapter.class);
    public static final String NAME = "maxmind_geoip";
    private final Config config;
    private final AtomicReference<DatabaseReader> databaseReader = new AtomicReference();
    private FileInfo fileInfo = FileInfo.empty();

    @Inject
    protected MaxmindDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
    }

    @Override
    protected void doStart() throws Exception {
        Path path = Paths.get(this.config.path(), new String[0]);
        this.fileInfo = FileInfo.forPath(path);
        if (!Files.isReadable(path)) {
            LOG.warn("Cannot read database file {}", (Object)this.config.path());
            this.setError(new IllegalStateException("Cannot read database file " + this.config.path()));
        } else {
            try {
                this.databaseReader.set(this.loadReader(path.toFile()));
            }
            catch (Exception e) {
                LOG.warn("Unable to read data base file {}", (Object)this.config.path());
                this.setError(e);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        DatabaseReader databaseReader = this.databaseReader.get();
        if (databaseReader != null) {
            databaseReader.close();
        }
    }

    @Override
    public Duration refreshInterval() {
        if (this.config.checkIntervalUnit() == null || this.config.checkInterval() == 0L) {
            return Duration.ZERO;
        }
        return Duration.millis((long)this.config.checkIntervalUnit().toMillis(this.config.checkInterval()));
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
        try {
            FileInfo.Change databaseFileCheck = this.fileInfo.checkForChange();
            if (!databaseFileCheck.isChanged() && !this.getError().isPresent()) {
                return;
            }
            LOG.debug("MaxMind database file has changed, reloading it from {}", (Object)this.config.path());
            DatabaseReader oldReader = this.databaseReader.get();
            try {
                this.databaseReader.set(this.loadReader(Paths.get(this.config.path(), new String[0]).toFile()));
                cachePurge.purgeAll();
                if (oldReader != null) {
                    oldReader.close();
                }
                this.fileInfo = databaseFileCheck.fileInfo();
                this.clearError();
            }
            catch (IOException e) {
                LOG.warn("Unable to load changed database file, leaving old one intact. Error message: {}", (Object)e.getMessage());
                this.setError(e);
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Unable to refresh MaxMind database file: {}", (Object)iae.getMessage());
            this.setError(iae);
        }
    }

    private DatabaseReader loadReader(File file) throws IOException {
        return new DatabaseReader.Builder(file).build();
    }

    @Override
    protected LookupResult doGet(Object key) {
        InetAddress addr;
        if (key instanceof InetAddress) {
            addr = (InetAddress)key;
        } else {
            try {
                addr = InetAddresses.forString((String)key.toString());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to parse IP address, returning empty result.");
                return LookupResult.empty();
            }
        }
        DatabaseReader reader = this.databaseReader.get();
        switch (this.config.dbType()) {
            case MAXMIND_CITY: {
                try {
                    String singleValue;
                    CityResponse city = reader.city(addr);
                    if (city == null) {
                        LOG.debug("No city data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    Location location = city.getLocation();
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    map.put("city", city.getCity());
                    map.put("continent", city.getContinent());
                    map.put("country", city.getCountry());
                    map.put("location", location);
                    map.put("postal", city.getPostal());
                    map.put("registered_country", city.getRegisteredCountry());
                    map.put("represented_country", city.getRepresentedCountry());
                    map.put("subdivisions", city.getSubdivisions());
                    map.put("traits", city.getTraits());
                    if (location == null || location.getLatitude() == null || location.getLongitude() == null) {
                        singleValue = null;
                    } else {
                        singleValue = location.getLatitude() + "," + location.getLongitude();
                        map.put("coordinates", singleValue);
                    }
                    return LookupResult.multi(singleValue, map);
                }
                catch (AddressNotFoundException nfe) {
                    LOG.debug("Unable to look up city data for IP address {}, returning empty result.", (Object)addr, (Object)nfe);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up city data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
            case MAXMIND_COUNTRY: {
                try {
                    CountryResponse countryResponse = reader.country(addr);
                    if (countryResponse == null) {
                        LOG.debug("No country data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    Country country = countryResponse.getCountry();
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    map.put("continent", countryResponse.getContinent());
                    map.put("country", country);
                    map.put("registered_country", countryResponse.getRegisteredCountry());
                    map.put("represented_country", countryResponse.getRepresentedCountry());
                    map.put("traits", countryResponse.getTraits());
                    String singleValue = country == null ? null : country.getIsoCode();
                    return LookupResult.multi(singleValue, map);
                }
                catch (AddressNotFoundException nfe) {
                    LOG.debug("Unable to look up country data for IP address {}, returning empty result.", (Object)addr, (Object)nfe);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up country data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
            case MAXMIND_ASN: {
                try {
                    AsnResponse asn = reader.asn(addr);
                    if (asn == null) {
                        LOG.debug("No ASN data for IP address {}, returning empty result.", (Object)addr);
                        return LookupResult.empty();
                    }
                    ImmutableMap map = ImmutableMap.of((Object)"as_number", (Object)asn.getAutonomousSystemNumber(), (Object)"as_organization", (Object)asn.getAutonomousSystemOrganization());
                    return LookupResult.multi(asn.getAutonomousSystemNumber(), (Map<Object, Object>)map);
                }
                catch (AddressNotFoundException nfe) {
                    LOG.debug("Unable to look up ASN data for IP address {}, returning empty result.", (Object)addr, (Object)nfe);
                    return LookupResult.empty();
                }
                catch (Exception e) {
                    LOG.warn("Unable to look up ASN data for IP address {}, returning empty result.", (Object)addr, (Object)e);
                    return LookupResult.empty();
                }
            }
        }
        return LookupResult.empty();
    }

    @Override
    public void set(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    void setDatabaseReader(DatabaseReader databaseReader) {
        this.databaseReader.set(databaseReader);
    }

    @VisibleForTesting
    DatabaseReader getDatabaseReader() {
        return this.databaseReader.get();
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=.AutoValue_MaxmindDataAdapter_Config.Builder.class)
    @JsonTypeName(value="maxmind_geoip")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="path")
        @NotEmpty
        public abstract String path();

        @JsonProperty(value="database_type")
        @NotNull
        public abstract DatabaseType dbType();

        @JsonProperty(value="check_interval")
        @Min(value=0L)
        public abstract @Min(value=0L) long checkInterval();

        @Nullable
        @JsonProperty(value="check_interval_unit")
        public abstract TimeUnit checkIntervalUnit();

        public static Builder builder() {
            return new .AutoValue_MaxmindDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate() {
            ArrayListMultimap errors = ArrayListMultimap.create();
            Path path = Paths.get(this.path(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                errors.put((Object)"path", (Object)"The file does not exist.");
            } else if (!Files.isReadable(path)) {
                errors.put((Object)"path", (Object)"The file cannot be read.");
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="path")
            public abstract Builder path(String var1);

            @JsonProperty(value="database_type")
            public abstract Builder dbType(DatabaseType var1);

            @JsonProperty(value="check_interval")
            public abstract Builder checkInterval(long var1);

            @JsonProperty(value="check_interval_unit")
            public abstract Builder checkIntervalUnit(@Nullable TimeUnit var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(MaxmindDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(MaxmindDataAdapter.NAME).checkInterval(1L).checkIntervalUnit(TimeUnit.MINUTES).path("/etc/graylog/server/GeoLite2-City.mmdb").dbType(DatabaseType.MAXMIND_CITY).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<MaxmindDataAdapter> {
        @Override
        public MaxmindDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

