/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.dates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class TimezoneAwareFunction
extends AbstractFunction<DateTime> {
    private static final String TIMEZONE = "timezone";
    private static final ImmutableMap<String, String> UPPER_ZONE_MAP = Maps.uniqueIndex((Iterable)DateTimeZone.getAvailableIDs(), input -> input != null ? input.toUpperCase(Locale.ENGLISH) : "UTC");
    private final ParameterDescriptor<String, DateTimeZone> timeZoneParam = ParameterDescriptor.string("timezone", DateTimeZone.class).transform(id -> DateTimeZone.forID((String)((String)UPPER_ZONE_MAP.getOrDefault((Object)id.toUpperCase(Locale.ENGLISH), (Object)"UTC")))).optional().description("The timezone to apply to the date, defaults to UTC").build();

    protected TimezoneAwareFunction() {
    }

    @Override
    public DateTime evaluate(FunctionArgs args, EvaluationContext context) {
        DateTimeZone timezone = this.timeZoneParam.optional(args, context).orElse(DateTimeZone.UTC);
        return this.evaluate(args, context, timezone);
    }

    protected abstract DateTime evaluate(FunctionArgs var1, EvaluationContext var2, DateTimeZone var3);

    @Override
    public FunctionDescriptor<DateTime> descriptor() {
        return FunctionDescriptor.builder().name(this.getName()).returnType(DateTime.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.builder().addAll(this.params()).add(this.timeZoneParam).build()).description(this.description()).build();
    }

    protected abstract String description();

    protected abstract String getName();

    protected abstract ImmutableList<ParameterDescriptor> params();
}

