/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.TypeLiteral;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class KeyValue
extends AbstractFunction<Map<String, String>> {
    public static final String NAME = "key_value";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The string to extract key/value pairs from").build();
    private final ParameterDescriptor<String, CharMatcher> splitParam = ParameterDescriptor.string("delimiters", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters used to separate pairs, defaults to whitespace").build();
    private final ParameterDescriptor<String, CharMatcher> valueSplitParam = ParameterDescriptor.string("kv_delimiters", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters used to separate keys from values, defaults to '='").build();
    private final ParameterDescriptor<Boolean, Boolean> ignoreEmptyValuesParam = ParameterDescriptor.bool("ignore_empty_values").optional().description("Whether to ignore keys with empty values, defaults to true").build();
    private final ParameterDescriptor<Boolean, Boolean> allowDupeKeysParam = ParameterDescriptor.bool("allow_dup_keys").optional().description("Whether to allow duplicate keys, defaults to true").build();
    private final ParameterDescriptor<String, String> duplicateHandlingParam = ParameterDescriptor.string("handle_dup_keys").optional().description("How to handle duplicate keys: 'take_first': only use first value, 'take_last': only take last value, default is to concatenate the values").build();
    private final ParameterDescriptor<String, CharMatcher> trimCharactersParam = ParameterDescriptor.string("trim_key_chars", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters to trim from keys, default is not to trim").build();
    private final ParameterDescriptor<String, CharMatcher> trimValueCharactersParam = ParameterDescriptor.string("trim_value_chars", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters to trim from values, default is not to trim").build();

    @Override
    public Map<String, String> evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        CharMatcher kvPairsMatcher = this.splitParam.optional(args, context).orElse(CharMatcher.whitespace());
        CharMatcher kvDelimMatcher = this.valueSplitParam.optional(args, context).orElse(CharMatcher.anyOf((CharSequence)"="));
        Splitter outerSplitter = Splitter.on((CharMatcher)kvPairsMatcher).omitEmptyStrings().trimResults();
        Splitter entrySplitter = Splitter.on((CharMatcher)kvDelimMatcher).omitEmptyStrings().limit(2).trimResults();
        return new MapSplitter(outerSplitter, entrySplitter, this.ignoreEmptyValuesParam.optional(args, context).orElse(true), this.trimCharactersParam.optional(args, context).orElse(CharMatcher.none()), this.trimValueCharactersParam.optional(args, context).orElse(CharMatcher.none()), this.allowDupeKeysParam.optional(args, context).orElse(true), this.duplicateHandlingParam.optional(args, context).orElse("take_first")).split(value);
    }

    @Override
    public FunctionDescriptor<Map<String, String>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(new TypeLiteral<Map<String, String>>(){}.getRawType()).params(this.valueParam, this.splitParam, this.valueSplitParam, this.ignoreEmptyValuesParam, this.allowDupeKeysParam, this.duplicateHandlingParam, this.trimCharactersParam, this.trimValueCharactersParam).description("Extracts key/value pairs from a string").build();
    }

    private static class MapSplitter {
        private final Splitter outerSplitter;
        private final Splitter entrySplitter;
        private final boolean ignoreEmptyValues;
        private final CharMatcher keyTrimMatcher;
        private final CharMatcher valueTrimMatcher;
        private final Boolean allowDupeKeys;
        private final String duplicateHandling;

        MapSplitter(Splitter outerSplitter, Splitter entrySplitter, boolean ignoreEmptyValues, CharMatcher keyTrimMatcher, CharMatcher valueTrimMatcher, Boolean allowDupeKeys, String duplicateHandling) {
            this.outerSplitter = outerSplitter;
            this.entrySplitter = entrySplitter;
            this.ignoreEmptyValues = ignoreEmptyValues;
            this.keyTrimMatcher = keyTrimMatcher;
            this.valueTrimMatcher = valueTrimMatcher;
            this.allowDupeKeys = allowDupeKeys;
            this.duplicateHandling = duplicateHandling;
        }

        public Map<String, String> split(CharSequence sequence) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            block8: for (String entry : this.outerSplitter.split(sequence)) {
                boolean concat = false;
                Iterator entryFields = this.entrySplitter.split((CharSequence)entry).iterator();
                if (!entryFields.hasNext()) continue;
                String key = (String)entryFields.next();
                if (map.containsKey(key = this.keyTrimMatcher.trimFrom((CharSequence)key))) {
                    if (!this.allowDupeKeys.booleanValue()) {
                        throw new IllegalArgumentException("Duplicate key " + key + " is not allowed in key_value function.");
                    }
                    switch (Strings.nullToEmpty((String)this.duplicateHandling).toLowerCase(Locale.ENGLISH)) {
                        case "take_first": {
                            continue block8;
                        }
                        case "take_last": {
                            break;
                        }
                        default: {
                            concat = true;
                        }
                    }
                }
                if (entryFields.hasNext()) {
                    String value = (String)entryFields.next();
                    value = this.valueTrimMatcher.trimFrom((CharSequence)value);
                    if (concat) {
                        value = (String)map.get(key) + this.duplicateHandling + value;
                    }
                    map.put(key, value);
                    continue;
                }
                if (this.ignoreEmptyValues) continue;
                throw new IllegalArgumentException("Missing value for key " + key);
            }
            return Collections.unmodifiableMap(map);
        }
    }
}

