/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.AggregationWidget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RandomUUIDProvider;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.TimeRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidgetPosition;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Widget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.WidgetPosition;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.AutoValue_QuickValuesConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.WidgetConfigBase;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.WidgetConfigWithQueryAndStreams;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AggregationConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.Pivot;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.Series;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.SeriesSortConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.SortConfig;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class QuickValuesConfig
extends WidgetConfigBase
implements WidgetConfigWithQueryAndStreams {
    private static final String VISUALIZATION_PIE = "pie";
    private static final String VISUALIZATION_TABLE = "table";
    private static final int DEFAULT_LIMIT = 15;
    private static final String DEFAULT_SORT_ORDER = "desc";

    public abstract String field();

    public abstract Boolean showDataTable();

    public abstract Boolean showPieChart();

    public abstract Optional<Integer> limit();

    public abstract Optional<Integer> dataTableLimit();

    public abstract Optional<String> sortOrder();

    public abstract Optional<String> stackedFields();

    private Series series() {
        return this.countSeries();
    }

    private List<Pivot> stackedFieldPivots() {
        String fieldNames = this.stackedFields().orElse("");
        return Strings.isNullOrEmpty((String)fieldNames) ? Collections.emptyList() : Splitter.on((String)",").splitToList((CharSequence)fieldNames).stream().map(fieldName -> this.valuesPivotForField((String)fieldName, 15)).collect(Collectors.toList());
    }

    private Pivot piePivot() {
        return this.valuesPivotForField(this.field(), this.limit().orElse(15));
    }

    private Pivot dataTablePivot() {
        return this.valuesPivotForField(this.field(), this.dataTableLimit().orElse(15));
    }

    private SortConfig.Direction order() {
        return this.sortDirection(this.sortOrder().orElse(DEFAULT_SORT_ORDER));
    }

    private SortConfig sort() {
        return SeriesSortConfig.create(this.series().function(), this.order());
    }

    @Override
    public Set<ViewWidget> toViewWidgets(Widget widget, RandomUUIDProvider randomUUIDProvider) {
        ImmutableSet.Builder viewWidgets = ImmutableSet.builder();
        AggregationConfig.Builder baseConfigBuilder = AggregationConfig.builder().sort(Collections.singletonList(this.sort())).series(Collections.singletonList(this.series()));
        if (this.showPieChart().booleanValue()) {
            AggregationWidget pieChart = this.createAggregationWidget(randomUUIDProvider.get()).config(baseConfigBuilder.rowPivots((List<Pivot>)ImmutableList.builder().add((Object)this.piePivot()).addAll(this.stackedFieldPivots()).build()).visualization(VISUALIZATION_PIE).build()).build();
            viewWidgets.add((Object)pieChart);
        }
        if (this.showDataTable().booleanValue()) {
            AggregationWidget dataTable = this.createAggregationWidget(randomUUIDProvider.get()).config(baseConfigBuilder.rowPivots((List<Pivot>)ImmutableList.builder().add((Object)this.dataTablePivot()).addAll(this.stackedFieldPivots()).build()).visualization(VISUALIZATION_TABLE).build()).build();
            viewWidgets.add((Object)dataTable);
        }
        return viewWidgets.build();
    }

    @Override
    public Map<String, ViewWidgetPosition> toViewWidgetPositions(Set<ViewWidget> viewWidgets, WidgetPosition widgetPosition) {
        if (viewWidgets.size() == 1) {
            return super.toViewWidgetPositions(viewWidgets, widgetPosition);
        }
        AggregationWidget pieWidget = viewWidgets.stream().filter(viewWidget -> viewWidget instanceof AggregationWidget).map(viewWidget -> (AggregationWidget)viewWidget).filter(viewWidget -> viewWidget.config().visualization().equals(VISUALIZATION_PIE)).findFirst().orElseThrow(() -> new RuntimeException("Unable to retrieve pie widget again."));
        int newPieHeight = (int)Math.ceil((double)widgetPosition.height() / 2.0);
        ViewWidgetPosition piePosition = ViewWidgetPosition.builder().col(widgetPosition.col()).row(widgetPosition.row()).height(newPieHeight).width(widgetPosition.width()).build();
        AggregationWidget tableWidget = viewWidgets.stream().filter(viewWidget -> viewWidget instanceof AggregationWidget).map(viewWidget -> (AggregationWidget)viewWidget).filter(viewWidget -> viewWidget.config().visualization().equals(VISUALIZATION_TABLE)).findFirst().orElseThrow(() -> new RuntimeException("Unable to retrieve table widget again."));
        ViewWidgetPosition tablePosition = ViewWidgetPosition.builder().col(widgetPosition.col()).row(widgetPosition.row() + newPieHeight).height(widgetPosition.height() - newPieHeight).width(widgetPosition.width()).build();
        return ImmutableMap.of((Object)pieWidget.id(), (Object)piePosition, (Object)tableWidget.id(), (Object)tablePosition);
    }

    @JsonCreator
    static QuickValuesConfig create(@JsonProperty(value="query") String query, @JsonProperty(value="timerange") TimeRange timerange, @JsonProperty(value="field") String field, @JsonProperty(value="show_data_table") @Nullable Boolean showDataTable, @JsonProperty(value="show_pie_chart") @Nullable Boolean showPieChart, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="data_table_limit") Integer dataTableLimit, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="stacked_fields") @Nullable String stackedFields, @JsonProperty(value="stream_id") @Nullable String streamId) {
        return new AutoValue_QuickValuesConfig(timerange, query, Optional.ofNullable(streamId), field, !(showDataTable != null && showDataTable != false || showPieChart != null && showPieChart != false) ? Boolean.valueOf(true) : (Boolean)MoreObjects.firstNonNull((Object)showDataTable, (Object)false), (Boolean)MoreObjects.firstNonNull((Object)showPieChart, (Object)false), Optional.ofNullable(limit), Optional.ofNullable(dataTableLimit), Optional.ofNullable(sortOrder), Optional.ofNullable(stackedFields));
    }
}

