/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Traverser;
import io.searchbox.client.JestClient;
import io.searchbox.core.MultiSearch;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Provider;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.ESQueryDecorators;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.IndexRangeContainsOneOfStreams;
import org.graylog.plugins.views.search.elasticsearch.QueryStringParser;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog.plugins.views.search.errors.SearchTypeErrorParser;
import org.graylog.plugins.views.search.filter.QueryStringFilter;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBackend
implements QueryBackend<ESGeneratedQueryContext> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchBackend.class);
    private final Map<String, Provider<ESSearchTypeHandler<? extends SearchType>>> elasticsearchSearchTypeHandlers;
    private final QueryStringParser queryStringParser;
    private final JestClient jestClient;
    private final IndexRangeService indexRangeService;
    private final StreamService streamService;
    private final ESQueryDecorators esQueryDecorators;
    private final ESGeneratedQueryContext.Factory queryContextFactory;

    @Inject
    public ElasticsearchBackend(Map<String, Provider<ESSearchTypeHandler<? extends SearchType>>> elasticsearchSearchTypeHandlers, QueryStringParser queryStringParser, JestClient jestClient, IndexRangeService indexRangeService, StreamService streamService, ESQueryDecorators esQueryDecorators, ESGeneratedQueryContext.Factory queryContextFactory) {
        this.elasticsearchSearchTypeHandlers = elasticsearchSearchTypeHandlers;
        this.queryStringParser = queryStringParser;
        this.jestClient = jestClient;
        this.indexRangeService = indexRangeService;
        this.streamService = streamService;
        this.esQueryDecorators = esQueryDecorators;
        this.queryContextFactory = queryContextFactory;
    }

    private QueryBuilder normalizeQueryString(String queryString) {
        return queryString.isEmpty() || queryString.trim().equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery((String)queryString).allowLeadingWildcard(Boolean.valueOf(true));
    }

    @Override
    public ESGeneratedQueryContext generate(SearchJob job, Query query, Set<QueryResult> results) {
        ElasticsearchQueryString backendQuery = (ElasticsearchQueryString)query.query();
        ImmutableSet<SearchType> searchTypes = query.searchTypes();
        String queryString = this.esQueryDecorators.decorate(backendQuery.queryString(), job, query, results);
        QueryBuilder normalizedRootQuery = this.normalizeQueryString(queryString);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter(normalizedRootQuery);
        this.generateFilterClause(query.filter(), job, query, results).map(arg_0 -> ((BoolQueryBuilder)boolQuery).filter(arg_0));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQuery).from(0).size(0);
        ESGeneratedQueryContext queryContext = this.queryContextFactory.create(this, searchSourceBuilder, job, query, results);
        for (SearchType searchType : searchTypes) {
            SearchSourceBuilder searchTypeSourceBuilder = queryContext.searchSourceBuilder(searchType);
            Set<String> effectiveStreamIds = searchType.effectiveStreams().isEmpty() ? query.usedStreamIds() : searchType.effectiveStreams();
            BoolQueryBuilder searchTypeOverrides = QueryBuilders.boolQuery().must(searchTypeSourceBuilder.query()).must(Objects.requireNonNull(IndexHelper.getTimestampRangeFilter(query.effectiveTimeRange(searchType)), "Timerange for search type " + searchType.id() + " cannot be found in query or search type.")).must((QueryBuilder)QueryBuilders.termsQuery((String)"streams", effectiveStreamIds));
            searchType.query().ifPresent(q -> {
                ElasticsearchQueryString searchTypeBackendQuery = (ElasticsearchQueryString)q;
                String searchTypeQueryString = this.esQueryDecorators.decorate(searchTypeBackendQuery.queryString(), job, query, results);
                QueryBuilder normalizedSearchTypeQuery = this.normalizeQueryString(searchTypeQueryString);
                searchTypeOverrides.must(normalizedSearchTypeQuery);
            });
            searchTypeSourceBuilder.query((QueryBuilder)searchTypeOverrides);
            String type = searchType.type();
            Provider<ESSearchTypeHandler<? extends SearchType>> searchTypeHandler = this.elasticsearchSearchTypeHandlers.get(type);
            if (searchTypeHandler == null) {
                LOG.error("Unknown search type {} for elasticsearch backend, cannot generate query part. Skipping this search type.", (Object)type);
                queryContext.addError(new SearchTypeError(query, searchType.id(), "Unknown search type '" + type + "' for elasticsearch backend, cannot generate query"));
                continue;
            }
            ((ESSearchTypeHandler)searchTypeHandler.get()).generateQueryPart(job, query, searchType, queryContext);
        }
        return queryContext;
    }

    public Optional<QueryBuilder> generateFilterClause(Filter filter, SearchJob job, Query query, Set<QueryResult> results) {
        if (filter == null) {
            return Optional.empty();
        }
        switch (filter.type()) {
            case "and": {
                BoolQueryBuilder andBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(filter1 -> this.generateFilterClause((Filter)filter1, job, query, results)).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(arg_0 -> ((BoolQueryBuilder)andBuilder).must(arg_0)));
                return Optional.of(andBuilder);
            }
            case "or": {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(filter1 -> this.generateFilterClause((Filter)filter1, job, query, results)).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(arg_0 -> ((BoolQueryBuilder)orBuilder).should(arg_0)));
                return Optional.of(orBuilder);
            }
            case "stream": {
                return Optional.empty();
            }
            case "query_string": {
                return Optional.of(QueryBuilders.queryStringQuery((String)this.esQueryDecorators.decorate(((QueryStringFilter)filter).query(), job, query, results)));
            }
        }
        return Optional.empty();
    }

    private Set<Stream> loadStreams(Set<String> streamIds) {
        return this.streamService.loadByIds(streamIds);
    }

    @Override
    public QueryResult doRun(SearchJob job, Query query, ESGeneratedQueryContext queryContext, Set<QueryResult> predecessorResults) {
        if (query.searchTypes().isEmpty()) {
            return QueryResult.builder().query(query).searchTypes(Collections.emptyMap()).errors(new HashSet<SearchError>(queryContext.errors())).build();
        }
        LOG.debug("Running query {} for job {}", (Object)query.id(), (Object)job.getId());
        HashMap resultsMap = Maps.newHashMap();
        Set<Stream> usedStreams = this.loadStreams(query.usedStreamIds());
        IndexRangeContainsOneOfStreams indexRangeContainsOneOfStreams = new IndexRangeContainsOneOfStreams(usedStreams);
        Set affectedIndices = this.indicesByTimeRange(query.timerange()).stream().filter(indexRangeContainsOneOfStreams).map(IndexRange::indexName).collect(Collectors.toSet());
        Map<String, SearchSourceBuilder> searchTypeQueries = queryContext.searchTypeQueries();
        ArrayList<String> searchTypeIds = new ArrayList<String>(searchTypeQueries.keySet());
        List searches = searchTypeIds.stream().map(searchTypeId -> {
            Set<String> affectedIndicesForSearchType = query.searchTypes().stream().filter(s -> s.id().equalsIgnoreCase((String)searchTypeId)).findFirst().flatMap(searchType -> {
                if (searchType.effectiveStreams().isEmpty() && !query.globalOverride().flatMap(GlobalOverride::timerange).isPresent() && !searchType.timerange().isPresent()) {
                    return Optional.empty();
                }
                Set<String> usedStreamIds = searchType.effectiveStreams().isEmpty() ? query.usedStreamIds() : searchType.effectiveStreams();
                Set<Stream> usedStreamsOfSearchType = this.loadStreams(usedStreamIds);
                return Optional.of(this.indicesByTimeRange(query.effectiveTimeRange((SearchType)searchType)).stream().filter(new IndexRangeContainsOneOfStreams(usedStreamsOfSearchType)).map(IndexRange::indexName).collect(Collectors.toSet()));
            }).orElse(affectedIndices);
            return ((Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(((SearchSourceBuilder)searchTypeQueries.get(searchTypeId)).toString()).addType("message")).addIndex(affectedIndicesForSearchType.isEmpty() ? Collections.singleton("") : affectedIndicesForSearchType)).allowNoIndices(false)).ignoreUnavailable(false)).build();
        }).collect(Collectors.toList());
        MultiSearch.Builder multiSearchBuilder = new MultiSearch.Builder(searches);
        MultiSearchResult result = (MultiSearchResult)JestUtils.execute(this.jestClient, multiSearchBuilder.build(), () -> "Unable to perform search query: ");
        for (SearchType searchType : query.searchTypes()) {
            ElasticsearchException e;
            String searchTypeId2 = searchType.id();
            Provider<ESSearchTypeHandler<? extends SearchType>> handlerProvider = this.elasticsearchSearchTypeHandlers.get(searchType.type());
            if (handlerProvider == null) {
                LOG.error("Unknown search type '{}', cannot convert query result.", (Object)searchType.type());
                continue;
            }
            ESSearchTypeHandler handler = (ESSearchTypeHandler)handlerProvider.get();
            int searchTypeIndex = searchTypeIds.indexOf(searchTypeId2);
            MultiSearchResult.MultiSearchResponse multiSearchResponse = (MultiSearchResult.MultiSearchResponse)result.getResponses().get(searchTypeIndex);
            if (multiSearchResponse.isError) {
                e = JestUtils.specificException(() -> "Search type returned error: ", multiSearchResponse.error);
                queryContext.addError(SearchTypeErrorParser.parse(query, searchTypeId2, e));
                continue;
            }
            if (this.checkForFailedShards(multiSearchResponse.searchResult).isPresent()) {
                e = this.checkForFailedShards(multiSearchResponse.searchResult).get();
                queryContext.addError(SearchTypeErrorParser.parse(query, searchTypeId2, e));
                continue;
            }
            SearchType.Result searchTypeResult = handler.extractResult(job, query, searchType, multiSearchResponse.searchResult, queryContext);
            if (searchTypeResult == null) continue;
            resultsMap.put(searchTypeId2, searchTypeResult);
        }
        LOG.debug("Query {} ran for job {}", (Object)query.id(), (Object)job.getId());
        return QueryResult.builder().query(query).searchTypes(resultsMap).errors(new HashSet<SearchError>(queryContext.errors())).build();
    }

    private Optional<ElasticsearchException> checkForFailedShards(SearchResult result) {
        JsonNode shards = result.getJsonObject().path("_shards");
        double failedShards = shards.path("failed").asDouble();
        if (failedShards > 0.0) {
            List<String> errors = StreamSupport.stream(shards.path("failures").spliterator(), false).map(failure -> failure.path("reason").path("reason").asText()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            List<String> nonNumericFieldErrors = errors.stream().filter(error -> error.startsWith("Expected numeric type on field")).collect(Collectors.toList());
            if (!nonNumericFieldErrors.isEmpty()) {
                return Optional.of(new FieldTypeException("Unable to perform search query: ", JestUtils.deduplicateErrors(nonNumericFieldErrors)));
            }
            return Optional.of(new ElasticsearchException("Unable to perform search query: ", JestUtils.deduplicateErrors(errors)));
        }
        return Optional.empty();
    }

    private Set<IndexRange> indicesByTimeRange(TimeRange timerange) {
        return this.indexRangeService.find(timerange.getFrom(), timerange.getTo());
    }

    private Set<String> queryStringsFromFilter(Filter entry) {
        if (entry != null) {
            Traverser filterTraverser = Traverser.forTree(filter -> (Set)MoreObjects.firstNonNull(filter.filters(), Collections.emptySet()));
            return StreamSupport.stream(filterTraverser.breadthFirst((Object)entry).spliterator(), false).filter(filter -> filter instanceof QueryStringFilter).map(queryStringFilter -> ((QueryStringFilter)queryStringFilter).query()).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public QueryMetadata parse(ImmutableSet<Parameter> declaredParameters, Query query) {
        Preconditions.checkArgument((boolean)(query.query() instanceof ElasticsearchQueryString));
        String mainQueryString = ((ElasticsearchQueryString)query.query()).queryString();
        java.util.stream.Stream<String> queryStringStreams = java.util.stream.Stream.concat(java.util.stream.Stream.of(mainQueryString), query.searchTypes().stream().flatMap(this::queryStringsFromSearchType));
        QueryMetadata metadataForParameters = queryStringStreams.map(this.queryStringParser::parse).reduce(QueryMetadata.builder().build(), (meta1, meta2) -> QueryMetadata.builder().usedParameterNames((Set<String>)Sets.union(meta1.usedParameterNames(), meta2.usedParameterNames())).build());
        return metadataForParameters;
    }

    private java.util.stream.Stream<String> queryStringsFromSearchType(SearchType searchType) {
        return java.util.stream.Stream.concat(searchType.query().filter(query -> query instanceof ElasticsearchQueryString).map(query -> ((ElasticsearchQueryString)query).queryString()).map(java.util.stream.Stream::of).orElse(java.util.stream.Stream.empty()), this.queryStringsFromFilter(searchType.filter()).stream());
    }
}

