/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.streams.Stream;

public class IndexRangeContainsOneOfStreams
implements Predicate<IndexRange> {
    private final Set<IndexSet> validIndexSets;
    private final Set<String> validStreamIds;

    public IndexRangeContainsOneOfStreams(Set<Stream> validStreams) {
        this.validStreamIds = validStreams.stream().map(Persisted::getId).collect(Collectors.toSet());
        this.validIndexSets = validStreams.stream().map(Stream::getIndexSet).collect(Collectors.toSet());
    }

    IndexRangeContainsOneOfStreams(Stream ... validStreams) {
        this((Set<Stream>)ImmutableSet.copyOf((Object[])validStreams));
    }

    @Override
    public boolean test(IndexRange indexRange) {
        if (this.validIndexSets.isEmpty() && this.validStreamIds.isEmpty()) {
            return false;
        }
        if (indexRange.streamIds() == null) {
            return this.validIndexSets.stream().anyMatch(indexSet -> indexSet.isManagedIndex(indexRange.indexName()));
        }
        return !Collections.disjoint(indexRange.streamIds(), this.validStreamIds);
    }
}

