/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class DBJobDefinitionService
extends PaginatedDbService<JobDefinitionDto> {
    private static final String COLLECTION_NAME = "scheduler_job_definitions";

    @Inject
    public DBJobDefinitionService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, JobDefinitionDto.class, COLLECTION_NAME);
    }

    public PaginatedList<JobDefinitionDto> getAllPaginated(String sortByField, int page, int perPage) {
        return this.findPaginatedWithQueryAndSort(DBQuery.empty(), DBSort.asc((String)sortByField), page, perPage);
    }

    public Optional<JobDefinitionDto> getByConfigField(String configField, Object value) {
        String field = String.format(Locale.US, "%s.%s", "config", configField);
        return Optional.ofNullable((JobDefinitionDto)this.db.findOne(DBQuery.is((String)field, (Object)value)));
    }
}

