/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.rest.requests.CreateJobTriggerRequest;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="JobScheduler", description="Scheduler management")
@Path(value="/scheduler")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class JobSchedulerResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerResource.class);
    private final DBJobTriggerService dbJobTriggerService;
    private final DBJobDefinitionService dbJobDefinitionService;

    @Inject
    public JobSchedulerResource(DBJobTriggerService dbJobTriggerService, DBJobDefinitionService dbJobDefinitionService) {
        this.dbJobTriggerService = dbJobTriggerService;
        this.dbJobDefinitionService = dbJobDefinitionService;
    }

    @GET
    @Path(value="/jobs")
    @ApiOperation(value="List all available jobs")
    public PaginatedResponse<JobDefinitionDto> listJobs(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage) {
        return PaginatedResponse.create("job_definitions", this.dbJobDefinitionService.getAllPaginated("title", page, perPage));
    }

    @GET
    @Path(value="/jobs/{jobDefinitionId}")
    @ApiOperation(value="Get a job definition ")
    public JobDefinitionDto get(@ApiParam(name="jobDefinitionId") @PathParam(value="jobDefinitionId") @NotBlank String jobDefinitionId) {
        return (JobDefinitionDto)this.dbJobDefinitionService.get(jobDefinitionId).orElseThrow(() -> new NotFoundException("Job definition " + jobDefinitionId + " doesn't exist"));
    }

    @POST
    @Path(value="/jobs")
    @ApiOperation(value="Create new job definition")
    @AuditEvent(type="scheduler:job:create")
    public JobDefinitionDto create(JobDefinitionDto dto) {
        return this.dbJobDefinitionService.save(dto);
    }

    @PUT
    @Path(value="/jobs/{jobDefinitionId}")
    @ApiOperation(value="Update existing job definition")
    @AuditEvent(type="scheduler:job:update")
    public JobDefinitionDto update(@ApiParam(name="jobDefinitionId") @PathParam(value="jobDefinitionId") @NotBlank String jobDefinitionId, JobDefinitionDto dto) {
        this.dbJobDefinitionService.get(jobDefinitionId).orElseThrow(() -> new NotFoundException("Job definition " + jobDefinitionId + " doesn't exist"));
        if (!jobDefinitionId.equals(dto.id())) {
            throw new BadRequestException("Job definition IDs don't match");
        }
        return this.dbJobDefinitionService.save(dto);
    }

    @DELETE
    @Path(value="/jobs/{jobDefinitionId}")
    @ApiOperation(value="Delete job definition")
    @AuditEvent(type="scheduler:job:delete")
    public void delete(@ApiParam(name="jobDefinitionId") @PathParam(value="jobDefinitionId") @NotBlank String jobDefinitionId) {
        this.dbJobDefinitionService.delete(jobDefinitionId);
    }

    @GET
    @Path(value="/triggers")
    @ApiOperation(value="List all available job triggers")
    public PaginatedResponse<JobTriggerDto> listTriggers() {
        List<JobTriggerDto> triggers = this.dbJobTriggerService.all();
        return PaginatedResponse.create("triggers", new PaginatedList<JobTriggerDto>(triggers, triggers.size(), 1, 50));
    }

    @POST
    @Path(value="/triggers")
    @ApiOperation(value="Create new job trigger")
    @AuditEvent(type="scheduler:trigger:create")
    public JobTriggerDto createTrigger(@Valid CreateJobTriggerRequest request) {
        try {
            return this.dbJobTriggerService.create(request.toDto());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

