/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.model.entities.EventListEntity;

final class AutoValue_EventListEntity
extends EventListEntity {
    private final Optional<String> name;
    private final Optional<DerivedTimeRange> timerange;
    private final Optional<BackendQuery> query;
    private final Set<String> streams;
    private final String type;
    private final String id;
    private final Filter filter;

    private AutoValue_EventListEntity(Optional<String> name, Optional<DerivedTimeRange> timerange, Optional<BackendQuery> query, Set<String> streams, String type, @Nullable String id, @Nullable Filter filter) {
        this.name = name;
        this.timerange = timerange;
        this.query = query;
        this.streams = streams;
        this.type = type;
        this.id = id;
        this.filter = filter;
    }

    @Override
    @JsonProperty
    public Optional<String> name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<DerivedTimeRange> timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty
    public Optional<BackendQuery> query() {
        return this.query;
    }

    @Override
    @JsonProperty
    public Set<String> streams() {
        return this.streams;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public Filter filter() {
        return this.filter;
    }

    public String toString() {
        return "EventListEntity{name=" + this.name + ", timerange=" + this.timerange + ", query=" + this.query + ", streams=" + this.streams + ", type=" + this.type + ", id=" + this.id + ", filter=" + this.filter + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventListEntity) {
            EventListEntity that = (EventListEntity)o;
            return this.name.equals(that.name()) && this.timerange.equals(that.timerange()) && this.query.equals(that.query()) && this.streams.equals(that.streams()) && this.type.equals(that.type()) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        return h$ ^= this.filter == null ? 0 : this.filter.hashCode();
    }

    @Override
    public EventListEntity.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EventListEntity.Builder {
        private Optional<String> name = Optional.empty();
        private Optional<DerivedTimeRange> timerange = Optional.empty();
        private Optional<BackendQuery> query = Optional.empty();
        private Set<String> streams;
        private String type;
        private String id;
        private Filter filter;

        Builder() {
        }

        private Builder(EventListEntity source) {
            this.name = source.name();
            this.timerange = source.timerange();
            this.query = source.query();
            this.streams = source.streams();
            this.type = source.type();
            this.id = source.id();
            this.filter = source.filter();
        }

        @Override
        public EventListEntity.Builder name(@Nullable String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        public EventListEntity.Builder timerange(@Nullable DerivedTimeRange timerange) {
            this.timerange = Optional.ofNullable(timerange);
            return this;
        }

        @Override
        public EventListEntity.Builder query(@Nullable BackendQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @Override
        public EventListEntity.Builder streams(Set<String> streams) {
            if (streams == null) {
                throw new NullPointerException("Null streams");
            }
            this.streams = streams;
            return this;
        }

        @Override
        public EventListEntity.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public EventListEntity.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public EventListEntity.Builder filter(@Nullable Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public EventListEntity build() {
            String missing = "";
            if (this.streams == null) {
                missing = missing + " streams";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EventListEntity(this.name, this.timerange, this.query, this.streams, this.type, this.id, this.filter);
        }
    }
}

