/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.parameters;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.graylog2.contentpacks.model.entities.references.ValueType;
import org.graylog2.contentpacks.model.parameters.FloatParameter;

final class AutoValue_FloatParameter
extends FloatParameter {
    private final String name;
    private final String title;
    private final String description;
    private final ValueType valueType;
    private final Optional<Float> defaultValue;

    private AutoValue_FloatParameter(String name, String title, String description, ValueType valueType, Optional<Float> defaultValue) {
        this.name = name;
        this.title = title;
        this.description = description;
        this.valueType = valueType;
        this.defaultValue = defaultValue;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="type")
    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    @JsonProperty(value="default_value")
    public Optional<Float> defaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "FloatParameter{name=" + this.name + ", title=" + this.title + ", description=" + this.description + ", valueType=" + (Object)((Object)this.valueType) + ", defaultValue=" + this.defaultValue + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FloatParameter) {
            FloatParameter that = (FloatParameter)o;
            return this.name.equals(that.name()) && this.title.equals(that.title()) && this.description.equals(that.description()) && this.valueType.equals((Object)that.valueType()) && this.defaultValue.equals(that.defaultValue());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueType.hashCode();
        h$ *= 1000003;
        return h$ ^= this.defaultValue.hashCode();
    }

    static final class Builder
    extends FloatParameter.Builder {
        private String name;
        private String title;
        private String description;
        private ValueType valueType;
        private Optional<Float> defaultValue = Optional.empty();

        Builder() {
        }

        @Override
        public FloatParameter.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public FloatParameter.Builder title(String title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public FloatParameter.Builder description(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public FloatParameter.Builder valueType(ValueType valueType) {
            if (valueType == null) {
                throw new NullPointerException("Null valueType");
            }
            this.valueType = valueType;
            return this;
        }

        @Override
        public FloatParameter.Builder defaultValue(Optional defaultValue) {
            if (defaultValue == null) {
                throw new NullPointerException("Null defaultValue");
            }
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        FloatParameter autoBuild() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.title == null) {
                missing = missing + " title";
            }
            if (this.description == null) {
                missing = missing + " description";
            }
            if (this.valueType == null) {
                missing = missing + " valueType";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FloatParameter(this.name, this.title, this.description, this.valueType, this.defaultValue);
        }
    }
}

