/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.github.zafarkhaja.semver.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexMappingTemplate;
import org.graylog2.indexer.indexset.IndexSetConfig;

public class EventsIndexMapping
implements IndexMappingTemplate {
    private final Version elasticsearchVersion;

    EventsIndexMapping(Version elasticsearchVersion) {
        this.elasticsearchVersion = elasticsearchVersion;
    }

    @Override
    public Map<String, Object> toTemplate(IndexSetConfig indexSetConfig, String indexPattern, int order) {
        String indexPatternsValue;
        String indexPatternsField;
        if (this.elasticsearchVersion.satisfies("^5.0.0")) {
            indexPatternsField = "template";
            indexPatternsValue = indexPattern;
        } else if (this.elasticsearchVersion.satisfies("^6.0.0")) {
            indexPatternsField = "index_patterns";
            indexPatternsValue = ImmutableSet.of((Object)indexPattern);
        } else {
            throw new ElasticsearchException("Unsupported Elasticsearch version: " + this.elasticsearchVersion);
        }
        String indexRefreshInterval = "1s";
        return this.map().put((Object)indexPatternsField, (Object)indexPatternsValue).put((Object)"order", (Object)order).put((Object)"settings", (Object)this.map().put((Object)"index.refresh_interval", (Object)"1s").build()).put((Object)"mappings", (Object)this.map().put((Object)"message", (Object)this.map().put((Object)"_source", (Object)this.map().put((Object)"enabled", (Object)true).build()).put((Object)"dynamic", (Object)false).put((Object)"dynamic_templates", (Object)this.list().add((Object)this.map().put((Object)"fields", (Object)this.map().put((Object)"path_match", (Object)"fields.*").put((Object)"mapping", (Object)this.map().put((Object)"type", (Object)"keyword").put((Object)"doc_values", (Object)true).put((Object)"index", (Object)true).build()).build()).build()).build()).put((Object)"properties", (Object)this.map().put((Object)"id", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"event_definition_type", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"event_definition_id", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"origin_context", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"timestamp", (Object)this.map().put((Object)"type", (Object)"date").put((Object)"format", (Object)"yyyy-MM-dd HH:mm:ss.SSS").build()).put((Object)"timestamp_processing", (Object)this.map().put((Object)"type", (Object)"date").put((Object)"format", (Object)"yyyy-MM-dd HH:mm:ss.SSS").build()).put((Object)"timerange_start", (Object)this.map().put((Object)"type", (Object)"date").put((Object)"format", (Object)"yyyy-MM-dd HH:mm:ss.SSS").build()).put((Object)"timerange_end", (Object)this.map().put((Object)"type", (Object)"date").put((Object)"format", (Object)"yyyy-MM-dd HH:mm:ss.SSS").build()).put((Object)"streams", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"source_streams", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"message", (Object)this.map().put((Object)"type", (Object)"text").put((Object)"analyzer", (Object)"standard").put((Object)"norms", (Object)false).put((Object)"fields", (Object)this.map().put((Object)"keyword", (Object)this.map().put((Object)"type", (Object)"keyword").build()).build()).build()).put((Object)"source", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"key", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"key_tuple", (Object)this.map().put((Object)"type", (Object)"keyword").build()).put((Object)"priority", (Object)this.map().put((Object)"type", (Object)"long").build()).put((Object)"alert", (Object)this.map().put((Object)"type", (Object)"boolean").build()).put((Object)"fields", (Object)this.map().put((Object)"type", (Object)"object").put((Object)"dynamic", (Object)true).build()).put((Object)"triggered_jobs", (Object)this.map().put((Object)"type", (Object)"keyword").build()).build()).build()).build()).build();
    }

    private ImmutableMap.Builder<String, Object> map() {
        return ImmutableMap.builder();
    }

    private ImmutableList.Builder<Object> list() {
        return ImmutableList.builder();
    }

    private ImmutableSet.Builder<Object> set() {
        return ImmutableSet.builder();
    }
}

