/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;

public class ExceptionLoggingChannelHandler
extends ChannelInboundHandlerAdapter {
    private final MessageInput input;
    private final Logger logger;

    public ExceptionLoggingChannelHandler(MessageInput input, Logger logger) {
        this.input = input;
        this.logger = logger;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.logger.isTraceEnabled() && "Connection reset by peer".equals(cause.getMessage())) {
            this.logger.trace("{} in Input [{}/{}] (channel {})", new Object[]{cause.getMessage(), this.input.getName(), this.input.getId(), ctx.channel()});
        } else {
            this.logger.error("Error in Input [{}/{}] (channel {}) (cause {})", new Object[]{this.input.getName(), this.input.getId(), ctx.channel(), cause});
        }
        ctx.close();
    }
}

