/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.events.CachesDeleted;
import org.graylog2.lookup.events.CachesUpdated;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class DBCacheService {
    private final JacksonDBCollection<CacheDto, ObjectId> db;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public DBCacheService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterEventBus) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection("lut_caches"), CacheDto.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.clusterEventBus = clusterEventBus;
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    public Optional<CacheDto> get(String idOrName) {
        try {
            return Optional.ofNullable((CacheDto)this.db.findOneById((Object)new ObjectId(idOrName)));
        }
        catch (IllegalArgumentException e) {
            return Optional.ofNullable((CacheDto)this.db.findOne(DBQuery.is((String)"name", (Object)idOrName)));
        }
    }

    public CacheDto save(CacheDto table) {
        WriteResult save = this.db.save((Object)table);
        CacheDto savedCache = (CacheDto)save.getSavedObject();
        this.clusterEventBus.post(CachesUpdated.create(savedCache.id()));
        return savedCache;
    }

    public PaginatedList<CacheDto> findPaginated(DBQuery.Query query, DBSort.SortBuilder sort, int page, int perPage) {
        try (DBCursor cursor = this.db.find(query).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));){
            PaginatedList<CacheDto> paginatedList = new PaginatedList<CacheDto>((List<CacheDto>)this.asImmutableList((Iterator<? extends CacheDto>)cursor), cursor.count(), page, perPage);
            return paginatedList;
        }
    }

    private ImmutableList<CacheDto> asImmutableList(Iterator<? extends CacheDto> cursor) {
        return ImmutableList.copyOf(cursor);
    }

    public void delete(String idOrName) {
        Optional<CacheDto> cacheDto = this.get(idOrName);
        cacheDto.map(CacheDto::id).map(ObjectId::new).ifPresent(arg_0 -> this.db.removeById(arg_0));
        cacheDto.ifPresent(cache -> this.clusterEventBus.post(CachesDeleted.create(cache.id())));
    }

    public Collection<CacheDto> findByIds(Set<String> idSet) {
        DBQuery.Query query = DBQuery.in((String)"_id", (Collection)idSet.stream().map(ObjectId::new).collect(Collectors.toList()));
        try (DBCursor cursor = this.db.find(query);){
            ImmutableList<CacheDto> immutableList = this.asImmutableList((Iterator<? extends CacheDto>)cursor);
            return immutableList;
        }
    }

    public Collection<CacheDto> findAll() {
        try (DBCursor cursor = this.db.find();){
            ImmutableList<CacheDto> immutableList = this.asImmutableList((Iterator<? extends CacheDto>)cursor);
            return immutableList;
        }
    }
}

