/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;

@JsonAutoDetect
public class ValidationResult {
    private final Multimap<String, String> errors = ArrayListMultimap.create();

    public void addError(String fieldName, String error) {
        this.errors.put((Object)fieldName, (Object)error);
    }

    public void addAll(Multimap<String, String> extraErrors) {
        this.errors.putAll(extraErrors);
    }

    public void addAll(ValidationResult validationResult) {
        this.errors.putAll(validationResult.errors);
    }

    @JsonProperty(value="failed")
    public boolean failed() {
        return !this.errors.isEmpty();
    }

    @JsonProperty(value="errors")
    public Map<String, Collection<String>> getErrors() {
        return this.errors.asMap();
    }
}

