/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.urlwhitelist;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.HashSet;
import java.util.List;
import org.graylog2.system.urlwhitelist.;
import org.graylog2.system.urlwhitelist.WhitelistEntry;

@JsonAutoDetect
@AutoValue
public abstract class UrlWhitelist {
    @JsonProperty(value="entries")
    public abstract List<WhitelistEntry> entries();

    @JsonProperty(value="disabled")
    public abstract boolean disabled();

    @JsonCreator
    public static UrlWhitelist create(@JsonProperty(value="entries") List<WhitelistEntry> entries, @JsonProperty(value="disabled") boolean disabled) {
        return UrlWhitelist.builder().entries(entries).disabled(disabled).build();
    }

    public static UrlWhitelist createEnabled(List<WhitelistEntry> entries) {
        return UrlWhitelist.builder().entries(entries).disabled(false).build();
    }

    public abstract Builder toBuilder();

    public boolean isWhitelisted(String url) {
        if (this.disabled()) {
            return true;
        }
        return this.entries().stream().anyMatch(e -> e.isWhitelisted(url));
    }

    public static Builder builder() {
        return new .AutoValue_UrlWhitelist.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder entries(List<WhitelistEntry> var1);

        public abstract Builder disabled(boolean var1);

        public abstract UrlWhitelist autoBuild();

        public UrlWhitelist build() {
            UrlWhitelist whitelist = this.autoBuild();
            this.checkForDuplicateIds(whitelist.entries());
            return whitelist;
        }

        private void checkForDuplicateIds(List<WhitelistEntry> entries) {
            HashSet ids = new HashSet();
            entries.forEach(entry -> {
                if (ids.contains(entry.id())) {
                    throw new IllegalArgumentException("Found duplicate ID '" + entry.id() + "' in whitelist entries.");
                }
                ids.add(entry.id());
            });
        }
    }
}

