/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Uninterruptibles;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import one.util.streamex.StreamEx;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchDomain;
import org.graylog.plugins.views.search.SearchExecutionGuard;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchMetadata;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.db.SearchJobService;
import org.graylog.plugins.views.search.engine.QueryEngine;
import org.graylog.plugins.views.search.events.SearchJobExecutionEvent;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Search")
@Path(value="/views/search")
@Produces(value={"application/json"})
@RequiresAuthentication
public class SearchResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private static final String BASE_PATH = "views/search";
    private final QueryEngine queryEngine;
    private final SearchDbService searchDbService;
    private final SearchJobService searchJobService;
    private final ObjectMapper objectMapper;
    private final PermittedStreams permittedStreams;
    private final SearchExecutionGuard executionGuard;
    private final SearchDomain searchDomain;
    private final EventBus serverEventBus;

    @Inject
    public SearchResource(QueryEngine queryEngine, SearchDbService searchDbService, SearchJobService searchJobService, ObjectMapper objectMapper, PermittedStreams permittedStreams, SearchExecutionGuard executionGuard, SearchDomain searchDomain, EventBus serverEventBus) {
        this.queryEngine = queryEngine;
        this.searchDbService = searchDbService;
        this.searchJobService = searchJobService;
        this.objectMapper = objectMapper;
        this.permittedStreams = permittedStreams;
        this.executionGuard = executionGuard;
        this.searchDomain = searchDomain;
        this.serverEventBus = serverEventBus;
    }

    @VisibleForTesting
    boolean isOwnerOfSearch(Search search, String username) {
        return search.owner().map(owner -> owner.equals(username)).orElse(true);
    }

    @POST
    @ApiOperation(value="Create a search query", response=Search.class, code=201)
    @AuditEvent(type="views:search:create")
    public Response createSearch(@ApiParam Search search) {
        String username = this.username();
        boolean isAdmin = this.getCurrentUser() != null && (this.getCurrentUser().isLocalAdmin() || this.isPermitted("*"));
        Optional<Search> previous = this.searchDbService.get(search.id());
        if (!isAdmin && !previous.map(existingSearch -> this.isOwnerOfSearch((Search)existingSearch, username)).orElse(true).booleanValue()) {
            throw new ForbiddenException("Unable to update search with id <" + search.id() + ">, already exists and user is not permitted to overwrite it.");
        }
        this.guard(search);
        Search saved = this.searchDbService.save(search.toBuilder().owner(username).build());
        if (saved == null || saved.id() == null) {
            return Response.serverError().build();
        }
        LOG.debug("Created new search object {}", (Object)saved.id());
        return Response.created((URI)URI.create(Objects.requireNonNull(saved.id()))).entity((Object)saved).build();
    }

    private String username() {
        return this.getCurrentUser() != null ? this.getCurrentUser().getName() : null;
    }

    @GET
    @ApiOperation(value="Retrieve a search query")
    @Path(value="{id}")
    public Search getSearch(@ApiParam(name="id") @PathParam(value="id") String searchId) {
        return this.searchDomain.getForUser(searchId, this.getCurrentUser(), this::hasViewReadPermission).orElseThrow(() -> new NotFoundException("Search with id " + searchId + " does not exist"));
    }

    private boolean hasViewReadPermission(ViewDTO view) {
        String viewId = view.id();
        return this.isPermitted("view:read", viewId) || view.type().equals((Object)ViewDTO.Type.DASHBOARD) && this.isPermitted("dashboards:read", viewId);
    }

    @GET
    @ApiOperation(value="Get all searches which the user may see")
    public List<Search> getAllSearches() {
        return this.searchDomain.getAllForUser(this.getCurrentUser(), this::hasViewReadPermission);
    }

    @POST
    @ApiOperation(value="Execute the referenced search query asynchronously", notes="Starts a new search, irrespective whether or not another is already running")
    @Path(value="{id}/execute")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    public Response executeQuery(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam Map<String, Object> executionState) {
        Search search = this.getSearch(id);
        search = search.addStreamsToQueriesWithoutStreams(this::loadAllAllowedStreamsForUser);
        this.guard(search);
        search = search.applyExecutionState(this.objectMapper, (Map)MoreObjects.firstNonNull(executionState, Collections.emptyMap()));
        SearchJob searchJob = this.searchJobService.create(search, this.username());
        this.postAuditEvent(searchJob);
        SearchJob runningSearchJob = this.queryEngine.execute(searchJob);
        return Response.created((URI)URI.create("views/search/status/" + runningSearchJob.getId())).entity((Object)runningSearchJob).build();
    }

    private void postAuditEvent(SearchJob searchJob) {
        SearchJobExecutionEvent searchJobExecutionEvent = SearchJobExecutionEvent.create(this.getCurrentUser(), searchJob, DateTime.now((DateTimeZone)DateTimeZone.UTC));
        this.serverEventBus.post((Object)searchJobExecutionEvent);
    }

    private ImmutableSet<String> loadAllAllowedStreamsForUser() {
        return this.permittedStreams.load(this::hasStreamReadPermission);
    }

    private boolean hasStreamReadPermission(String streamId) {
        return this.isPermitted("streams:read", streamId);
    }

    private void guard(Search search) {
        this.executionGuard.check(search, this::hasStreamReadPermission);
    }

    @POST
    @ApiOperation(value="Execute a new synchronous search", notes="Executes a new search and waits for its result")
    @Path(value="sync")
    @NoAuditEvent(value="Creating audit event manually in method body.")
    public Response executeSyncJob(@ApiParam Search search, @ApiParam(name="timeout", defaultValue="60000") @QueryParam(value="timeout") @DefaultValue(value="60000") long timeout) {
        String username = this.username();
        search = search.addStreamsToQueriesWithoutStreams(this::loadAllAllowedStreamsForUser);
        this.guard(search);
        SearchJob searchJob = this.queryEngine.execute(this.searchJobService.create(search, username));
        this.postAuditEvent(searchJob);
        try {
            Uninterruptibles.getUninterruptibly(searchJob.getResultFuture(), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            LOG.error("Error executing search job <{}>", (Object)searchJob.getId(), (Object)e);
            throw new InternalServerErrorException("Error executing search job: " + e.getMessage());
        }
        catch (TimeoutException e) {
            throw new InternalServerErrorException("Timeout while executing search job");
        }
        catch (Exception e) {
            LOG.error("Other error", (Throwable)e);
            throw e;
        }
        return Response.ok((Object)searchJob).build();
    }

    @GET
    @ApiOperation(value="Retrieve the status of an executed query")
    @Path(value="status/{jobId}")
    public SearchJob jobStatus(@ApiParam(name="jobId") @PathParam(value="jobId") String jobId) {
        SearchJob searchJob = this.searchJobService.load(jobId, this.username()).orElseThrow(NotFoundException::new);
        try {
            Uninterruptibles.getUninterruptibly(searchJob.getResultFuture(), (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        return searchJob;
    }

    @GET
    @ApiOperation(value="Metadata for the given Search object", notes="Used for already persisted search objects")
    @Path(value="metadata/{searchId}")
    public SearchMetadata metadata(@ApiParam(value="searchId") @PathParam(value="searchId") String searchId) {
        Search search = this.getSearch(searchId);
        return this.metadataForObject(search);
    }

    @POST
    @ApiOperation(value="Metadata for the posted Search object", notes="Intended for search objects that aren't yet persisted (e.g. for validation or interactive purposes)")
    @Path(value="metadata")
    @NoAuditEvent(value="Only returning metadata for given search, not changing any data")
    public SearchMetadata metadataForObject(@ApiParam @NotNull Search search) {
        if (search == null) {
            throw new IllegalArgumentException("Search must not be null.");
        }
        Map queryMetadatas = StreamEx.of(search.queries()).toMap(Query::id, query -> this.queryEngine.parse(search, (Query)query));
        return SearchMetadata.create(queryMetadatas, (ImmutableMap<String, Parameter>)Maps.uniqueIndex(search.parameters(), Parameter::name));
    }
}

