/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.elasticsearch.IndexRangeContainsOneOfStreams;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;

public class IndexLookup {
    private final IndexRangeService indexRangeService;
    private final StreamService streamService;
    BiFunction<IndexRange, Set<Stream>, Boolean> indexRangeContainsOneOfStreams = this::indexRangeContainsOneOfStreams;

    @Inject
    public IndexLookup(IndexRangeService indexRangeService, StreamService streamService) {
        this.indexRangeService = indexRangeService;
        this.streamService = streamService;
    }

    public Set<String> indexNamesForStreamsInTimeRange(Set<String> streamIds, TimeRange timeRange) {
        if (streamIds.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Stream> usedStreams = this.streamService.loadByIds(streamIds);
        SortedSet<IndexRange> candidateIndices = this.indexRangeService.find(timeRange.getFrom(), timeRange.getTo());
        return candidateIndices.stream().filter(i -> this.indexRangeContainsOneOfStreams.apply((IndexRange)i, usedStreams)).map(IndexRange::indexName).collect(Collectors.toSet());
    }

    private boolean indexRangeContainsOneOfStreams(IndexRange indexRange, Set<Stream> streams) {
        return new IndexRangeContainsOneOfStreams(streams).test(indexRange);
    }
}

