/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.export.ExportException;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.MessagesRequest;
import org.graylog.plugins.views.search.export.QueryStringDecorator;
import org.graylog.plugins.views.search.export.ResultFormat;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class CommandFactory {
    private final QueryStringDecorator queryStringDecorator;

    @Inject
    public CommandFactory(QueryStringDecorator queryStringDecorator) {
        this.queryStringDecorator = queryStringDecorator;
    }

    public ExportMessagesCommand buildFromRequest(MessagesRequest request) {
        ExportMessagesCommand.Builder builder = ExportMessagesCommand.builder().timeRange(this.toAbsolute(request.timeRange())).queryString(request.queryString()).streams(request.streams()).fieldsInOrder(request.fieldsInOrder()).chunkSize(request.chunkSize());
        if (request.limit().isPresent()) {
            builder.limit(request.limit().getAsInt());
        }
        return builder.build();
    }

    public ExportMessagesCommand buildWithSearchOnly(Search search, ResultFormat resultFormat) {
        Query query = this.queryFrom(search);
        return this.builderFrom(resultFormat).timeRange(this.toAbsolute(query.timerange())).queryString(this.queryStringFrom(search, query)).streams(query.usedStreamIds()).build();
    }

    private Query queryFrom(Search s) {
        if (s.queries().size() > 1) {
            throw new ExportException("Can't get messages for search with id " + s.id() + ", because it contains multiple queries");
        }
        return (Query)s.queries().stream().findFirst().orElseThrow(() -> new ExportException("Invalid Search object with empty Query"));
    }

    public ExportMessagesCommand buildWithMessageList(Search search, String messageListId, ResultFormat resultFormat) {
        Query query = search.queryForSearchType(messageListId);
        MessageList messageList = this.messageListFrom(query, messageListId);
        ExportMessagesCommand.Builder commandBuilder = this.builderFrom(resultFormat).timeRange(this.toAbsolute(this.timeRangeFrom(query, messageList))).queryString(this.queryStringFrom(search, query, messageList)).streams(this.streamsFrom(query, messageList)).decorators(messageList.decorators());
        return commandBuilder.build();
    }

    private MessageList messageListFrom(Query query, String searchTypeId) {
        SearchType searchType = query.searchTypes().stream().filter(st -> st.id().equals(searchTypeId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Error getting search type"));
        if (!(searchType instanceof MessageList)) {
            throw new ExportException("export is not supported for search type " + searchType.getClass());
        }
        return (MessageList)searchType;
    }

    private AbsoluteRange toAbsolute(TimeRange timeRange) {
        return AbsoluteRange.create(timeRange.getFrom(), timeRange.getTo());
    }

    private ExportMessagesCommand.Builder builderFrom(ResultFormat resultFormat) {
        ExportMessagesCommand.Builder requestBuilder = ExportMessagesCommand.builder();
        requestBuilder.fieldsInOrder(resultFormat.fieldsInOrder());
        if (resultFormat.limit().isPresent()) {
            requestBuilder.limit(resultFormat.limit().getAsInt());
        }
        return requestBuilder;
    }

    private TimeRange timeRangeFrom(Query query, MessageList ml) {
        if (ml.timerange().isPresent()) {
            return query.effectiveTimeRange(ml);
        }
        return query.timerange();
    }

    private ElasticsearchQueryString queryStringFrom(Search search, Query query) {
        ElasticsearchQueryString undecorated = this.queryStringFrom(query);
        return this.decorateQueryString(search, query, undecorated);
    }

    private ElasticsearchQueryString queryStringFrom(Search search, Query query, MessageList messageList) {
        ElasticsearchQueryString undecorated = this.pickQueryString(messageList, query);
        return this.decorateQueryString(search, query, undecorated);
    }

    private ElasticsearchQueryString pickQueryString(MessageList messageList, Query query) {
        if (messageList.query().isPresent() && this.hasQueryString(query)) {
            return this.esQueryStringFrom(query).concatenate(this.esQueryStringFrom(messageList));
        }
        if (messageList.query().isPresent()) {
            return this.esQueryStringFrom(messageList);
        }
        return this.queryStringFrom(query);
    }

    private boolean hasQueryString(Query query) {
        return query.query() instanceof ElasticsearchQueryString;
    }

    private ElasticsearchQueryString queryStringFrom(Query query) {
        return this.hasQueryString(query) ? this.esQueryStringFrom(query) : ElasticsearchQueryString.empty();
    }

    private ElasticsearchQueryString esQueryStringFrom(MessageList ml) {
        return (ElasticsearchQueryString)ml.query().get();
    }

    private ElasticsearchQueryString esQueryStringFrom(Query query) {
        return (ElasticsearchQueryString)query.query();
    }

    private ElasticsearchQueryString decorateQueryString(Search search, Query query, ElasticsearchQueryString undecorated) {
        String queryString = undecorated.queryString();
        String decorated = this.queryStringDecorator.decorateQueryString(queryString, search, query);
        return ElasticsearchQueryString.builder().queryString(decorated).build();
    }

    private Set<String> streamsFrom(Query query, MessageList messageList) {
        return messageList.effectiveStreams().isEmpty() ? query.usedStreamIds() : messageList.effectiveStreams();
    }
}

