/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoCommandException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBUpsertRetryer {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBUpsertRetryer.class);

    public static <T> T run(Callable<T> c) {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(t -> t instanceof DuplicateKeyException && ((DuplicateKeyException)t).getErrorCode() == 11000 || t instanceof MongoCommandException && ((MongoCommandException)t).getErrorCode() == 11000).withStopStrategy(StopStrategies.stopAfterAttempt((int)2)).withRetryListener(new RetryListener(){

            public <V> void onRetry(Attempt<V> attempt) {
                if (attempt.hasException()) {
                    LOG.debug("Upsert failed with {}. Retrying request", (Object)attempt.getExceptionCause().toString());
                }
            }
        }).build();
        try {
            return (T)retryer.call(c);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (RetryException e) {
            if (e.getCause() instanceof DuplicateKeyException) {
                throw (DuplicateKeyException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }
}

