/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.health;

import java.util.stream.Stream;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog2.indexer.cluster.health.AbsoluteValueWatermarkSettings;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettings;
import org.graylog2.indexer.cluster.health.PercentageWatermarkSettings;
import org.graylog2.indexer.cluster.health.WatermarkSettings;

public class ClusterAllocationDiskSettingsFactory {
    public static ClusterAllocationDiskSettings create(boolean enabled, String low, String high, String floodStage) throws Exception {
        if (!enabled) {
            return ClusterAllocationDiskSettings.create(enabled, null);
        }
        return ClusterAllocationDiskSettings.create(enabled, ClusterAllocationDiskSettingsFactory.createWatermarkSettings(low, high, floodStage));
    }

    private static WatermarkSettings<?> createWatermarkSettings(String low, String high, String floodStage) throws Exception {
        WatermarkSettings.SettingsType lowType = ClusterAllocationDiskSettingsFactory.getType(low);
        WatermarkSettings.SettingsType highType = ClusterAllocationDiskSettingsFactory.getType(high);
        if (Stream.of(lowType, highType).allMatch(s -> s == WatermarkSettings.SettingsType.ABSOLUTE)) {
            AbsoluteValueWatermarkSettings.Builder builder = new AbsoluteValueWatermarkSettings.Builder().low(ByteSizeValue.parseBytesSizeValue((String)low, (String)"lowWatermark")).high(ByteSizeValue.parseBytesSizeValue((String)high, (String)"highWatermark"));
            if (!floodStage.isEmpty()) {
                builder.floodStage(ByteSizeValue.parseBytesSizeValue((String)floodStage, (String)"floodStageWatermark"));
            }
            return builder.build();
        }
        if (Stream.of(lowType, highType).allMatch(s -> s == WatermarkSettings.SettingsType.PERCENTAGE)) {
            PercentageWatermarkSettings.Builder builder = new PercentageWatermarkSettings.Builder().low(ClusterAllocationDiskSettingsFactory.getPercentageValue(low)).high(ClusterAllocationDiskSettingsFactory.getPercentageValue(high));
            if (!floodStage.isEmpty()) {
                builder.floodStage(ClusterAllocationDiskSettingsFactory.getPercentageValue(floodStage));
            }
            return builder.build();
        }
        throw new Exception("Error creating ClusterAllocationDiskWatermarkSettings. This should never happen.");
    }

    private static WatermarkSettings.SettingsType getType(String value) {
        if (value.trim().endsWith("%")) {
            return WatermarkSettings.SettingsType.PERCENTAGE;
        }
        return WatermarkSettings.SettingsType.ABSOLUTE;
    }

    private static Double getPercentageValue(String value) {
        return Double.parseDouble(value.trim().replace("%", ""));
    }
}

