/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public abstract class QuickvaluesBaseWidgetStrategy
implements WidgetStrategy {
    protected final String query;
    @Nullable
    protected final String streamId;
    protected final String field;
    protected final Searches searches;
    protected final TimeRange timeRange;
    protected final String sortOrder;
    protected final List<String> stackedFields;

    QuickvaluesBaseWidgetStrategy(Searches searches, TimeRange timeRange, Map<String, Object> config, String widgetId) throws InvalidWidgetConfigurationException {
        this.searches = searches;
        this.timeRange = timeRange;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        this.query = (String)config.get("query");
        this.field = (String)config.get("field");
        this.streamId = (String)config.get("stream_id");
        this.sortOrder = (String)MoreObjects.firstNonNull((Object)config.get("sort_order"), (Object)"desc");
        this.stackedFields = QuickvaluesBaseWidgetStrategy.getStackedFields(config.get("stacked_fields"));
    }

    private static List<String> getStackedFields(@Nullable Object value) {
        String stackedFieldsString = (String)MoreObjects.firstNonNull((Object)value, (Object)"");
        return Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)stackedFieldsString);
    }

    protected static Sorting.Direction getSortingDirection(String sort) {
        if (Strings.isNullOrEmpty((String)sort)) {
            return Sorting.Direction.DESC;
        }
        try {
            return Sorting.Direction.valueOf(sort.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            return Sorting.Direction.DESC;
        }
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("field");
    }
}

