/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.zafarkhaja.semver.Version;
import com.google.common.collect.ImmutableSet;
import io.searchbox.client.JestClient;
import io.searchbox.cluster.State;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.cluster.Node;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20170607164210_MigrateReopenedIndicesToAliases
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20170607164210_MigrateReopenedIndicesToAliases.class);
    private static final String REOPENED_INDEX_SETTING = "graylog2_reopened";
    private Node node;
    private final IndexSetService indexSetService;
    private final MongoIndexSet.Factory mongoIndexSetFactory;
    private final Indices indices;
    private final JestClient jestClient;

    @Inject
    public V20170607164210_MigrateReopenedIndicesToAliases(Node node, IndexSetService indexSetService, MongoIndexSet.Factory mongoIndexSetFactory, Indices indices, JestClient jestClient) {
        this.node = node;
        this.indexSetService = indexSetService;
        this.mongoIndexSetFactory = mongoIndexSetFactory;
        this.indices = indices;
        this.jestClient = jestClient;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2017-06-07T16:42:10Z");
    }

    @Override
    public void upgrade() {
        this.indexSetService.findAll().stream().map(this.mongoIndexSetFactory::create).flatMap(indexSet -> this.getReopenedIndices((IndexSet)indexSet).stream()).map(indexName -> {
            LOG.debug("Marking index {} to be reopened using alias.", indexName);
            return indexName;
        }).forEach(this.indices::markIndexReopened);
    }

    private Set<String> getReopenedIndices(Collection<String> indices) {
        Version elasticsearchVersion = this.node.getVersion().orElseThrow(() -> new ElasticsearchException("Unable to retrieve Elasticsearch version."));
        String indexList = String.join((CharSequence)",", indices);
        State request = new State.Builder().withMetadata().indices(indexList).build();
        Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read cluster state for reopened indices " + indices);
        JsonNode clusterStateJson = jestResult.getJsonObject();
        JsonNode indicesJson = clusterStateJson.path("metadata").path("indices");
        ImmutableSet.Builder reopenedIndices = ImmutableSet.builder();
        if (indicesJson.isMissingNode()) {
            LOG.error("Retrieved cluster state is invalid (no metadata.indices key).");
            LOG.debug("Received cluster state was: {}", (Object)clusterStateJson.toString());
            return Collections.emptySet();
        }
        Iterator it = indicesJson.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String indexName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            JsonNode indexSettings = value.path("settings");
            if (indexSettings.isMissingNode()) {
                LOG.error("Unable to retrieve index settings from metadata for index {} - skipping.", (Object)indexName);
                LOG.debug("Index metadata was: {}", (Object)value.toString());
                continue;
            }
            if (!this.checkForReopened(indexSettings, elasticsearchVersion)) continue;
            LOG.debug("Adding {} to list of indices to be migrated.", (Object)indexName);
            reopenedIndices.add((Object)indexName);
        }
        return reopenedIndices.build();
    }

    private boolean checkForReopened(@Nonnull JsonNode indexSettings, Version elasticsearchVersion) {
        JsonNode settings;
        if (elasticsearchVersion.satisfies(">=2.1.0 & <5.0.0")) {
            settings = indexSettings;
        } else if (elasticsearchVersion.satisfies("^5.0.0 | ^6.0.0")) {
            settings = indexSettings.path("archived");
        } else {
            throw new ElasticsearchException("Unsupported Elasticsearch version: " + elasticsearchVersion);
        }
        return settings.path("index").path(REOPENED_INDEX_SETTING).asBoolean();
    }

    private Set<String> getReopenedIndices(IndexSet indexSet) {
        return this.getReopenedIndices(Collections.singleton(indexSet.getIndexWildcard()));
    }
}

