/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models.system.sessions.responses;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import javax.inject.Inject;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.graylog2.rest.models.system.sessions.responses.DefaultSessionResponse;
import org.graylog2.rest.models.system.sessions.responses.SessionResponseFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DefaultSessionResponseFactory
implements SessionResponseFactory {
    protected final ObjectMapper objectMapper;

    @Inject
    public DefaultSessionResponseFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public JsonNode forSession(Session session) {
        Date validUntil = this.getValidUntil(session);
        String id = session.getId().toString();
        String username = this.getSubjectFromSession(session).getPrincipal().toString();
        return this.toJsonNode(DefaultSessionResponse.create(validUntil, id, username));
    }

    protected Date getValidUntil(Session session) {
        return new DateTime((Object)session.getLastAccessTime(), DateTimeZone.UTC).plus(session.getTimeout()).toDate();
    }

    protected Subject getSubjectFromSession(Session session) {
        return new Subject.Builder().sessionId(session.getId()).buildSubject();
    }

    protected JsonNode toJsonNode(Object object) {
        return this.objectMapper.valueToTree(object);
    }
}

