package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.events.notifications.NotificationParameters;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventNotificationHandlerConfigEntity extends EventNotificationHandlerConfigEntity {

  private final ValueReference notificationId;

  private final Optional<NotificationParameters> notificationParameters;

  private AutoValue_EventNotificationHandlerConfigEntity(
      ValueReference notificationId,
      Optional<NotificationParameters> notificationParameters) {
    this.notificationId = notificationId;
    this.notificationParameters = notificationParameters;
  }

  @JsonProperty("notification_id")
  @Override
  public ValueReference notificationId() {
    return notificationId;
  }

  @JsonProperty("notification_parameters")
  @Override
  public Optional<NotificationParameters> notificationParameters() {
    return notificationParameters;
  }

  @Override
  public String toString() {
    return "EventNotificationHandlerConfigEntity{"
        + "notificationId=" + notificationId + ", "
        + "notificationParameters=" + notificationParameters
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventNotificationHandlerConfigEntity) {
      EventNotificationHandlerConfigEntity that = (EventNotificationHandlerConfigEntity) o;
      return this.notificationId.equals(that.notificationId())
          && this.notificationParameters.equals(that.notificationParameters());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= notificationId.hashCode();
    h$ *= 1000003;
    h$ ^= notificationParameters.hashCode();
    return h$;
  }

  @Override
  public EventNotificationHandlerConfigEntity.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventNotificationHandlerConfigEntity.Builder {
    private ValueReference notificationId;
    private Optional<NotificationParameters> notificationParameters = Optional.empty();
    Builder() {
    }
    private Builder(EventNotificationHandlerConfigEntity source) {
      this.notificationId = source.notificationId();
      this.notificationParameters = source.notificationParameters();
    }
    @Override
    public EventNotificationHandlerConfigEntity.Builder notificationId(ValueReference notificationId) {
      if (notificationId == null) {
        throw new NullPointerException("Null notificationId");
      }
      this.notificationId = notificationId;
      return this;
    }
    @Override
    public EventNotificationHandlerConfigEntity.Builder notificationParameters(@Nullable NotificationParameters notificationParameters) {
      this.notificationParameters = Optional.ofNullable(notificationParameters);
      return this;
    }
    @Override
    public EventNotificationHandlerConfigEntity build() {
      String missing = "";
      if (this.notificationId == null) {
        missing += " notificationId";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventNotificationHandlerConfigEntity(
          this.notificationId,
          this.notificationParameters);
    }
  }

}
