package org.graylog.events.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventDto extends EventDto {

  private final String id;

  private final String eventDefinitionType;

  private final String eventDefinitionId;

  private final Optional<String> originContext;

  private final DateTime eventTimestamp;

  private final DateTime processingTimestamp;

  private final Optional<DateTime> timerangeStart;

  private final Optional<DateTime> timerangeEnd;

  private final Set<String> streams;

  private final Set<String> sourceStreams;

  private final String message;

  private final String source;

  private final List<String> keyTuple;

  private final String key;

  private final long priority;

  private final boolean alert;

  private final Map<String, String> fields;

  private final Map<String, String> groupByFields;

  private AutoValue_EventDto(
      String id,
      String eventDefinitionType,
      String eventDefinitionId,
      Optional<String> originContext,
      DateTime eventTimestamp,
      DateTime processingTimestamp,
      Optional<DateTime> timerangeStart,
      Optional<DateTime> timerangeEnd,
      Set<String> streams,
      Set<String> sourceStreams,
      String message,
      String source,
      List<String> keyTuple,
      @Nullable String key,
      long priority,
      boolean alert,
      Map<String, String> fields,
      Map<String, String> groupByFields) {
    this.id = id;
    this.eventDefinitionType = eventDefinitionType;
    this.eventDefinitionId = eventDefinitionId;
    this.originContext = originContext;
    this.eventTimestamp = eventTimestamp;
    this.processingTimestamp = processingTimestamp;
    this.timerangeStart = timerangeStart;
    this.timerangeEnd = timerangeEnd;
    this.streams = streams;
    this.sourceStreams = sourceStreams;
    this.message = message;
    this.source = source;
    this.keyTuple = keyTuple;
    this.key = key;
    this.priority = priority;
    this.alert = alert;
    this.fields = fields;
    this.groupByFields = groupByFields;
  }

  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("event_definition_type")
  @Override
  public String eventDefinitionType() {
    return eventDefinitionType;
  }

  @JsonProperty("event_definition_id")
  @Override
  public String eventDefinitionId() {
    return eventDefinitionId;
  }

  @JsonProperty("origin_context")
  @Override
  public Optional<String> originContext() {
    return originContext;
  }

  @JsonProperty("timestamp")
  @Override
  public DateTime eventTimestamp() {
    return eventTimestamp;
  }

  @JsonProperty("timestamp_processing")
  @Override
  public DateTime processingTimestamp() {
    return processingTimestamp;
  }

  @JsonProperty("timerange_start")
  @Override
  public Optional<DateTime> timerangeStart() {
    return timerangeStart;
  }

  @JsonProperty("timerange_end")
  @Override
  public Optional<DateTime> timerangeEnd() {
    return timerangeEnd;
  }

  @JsonProperty("streams")
  @Override
  public Set<String> streams() {
    return streams;
  }

  @JsonProperty("source_streams")
  @Override
  public Set<String> sourceStreams() {
    return sourceStreams;
  }

  @JsonProperty("message")
  @Override
  public String message() {
    return message;
  }

  @JsonProperty("source")
  @Override
  public String source() {
    return source;
  }

  @JsonProperty("key_tuple")
  @Override
  public List<String> keyTuple() {
    return keyTuple;
  }

  @JsonProperty("key")
  @Nullable
  @Override
  public String key() {
    return key;
  }

  @JsonProperty("priority")
  @Override
  public long priority() {
    return priority;
  }

  @JsonProperty("alert")
  @Override
  public boolean alert() {
    return alert;
  }

  @JsonProperty("fields")
  @Override
  public Map<String, String> fields() {
    return fields;
  }

  @JsonProperty("group_by_fields")
  @Override
  public Map<String, String> groupByFields() {
    return groupByFields;
  }

  @Override
  public String toString() {
    return "EventDto{"
        + "id=" + id + ", "
        + "eventDefinitionType=" + eventDefinitionType + ", "
        + "eventDefinitionId=" + eventDefinitionId + ", "
        + "originContext=" + originContext + ", "
        + "eventTimestamp=" + eventTimestamp + ", "
        + "processingTimestamp=" + processingTimestamp + ", "
        + "timerangeStart=" + timerangeStart + ", "
        + "timerangeEnd=" + timerangeEnd + ", "
        + "streams=" + streams + ", "
        + "sourceStreams=" + sourceStreams + ", "
        + "message=" + message + ", "
        + "source=" + source + ", "
        + "keyTuple=" + keyTuple + ", "
        + "key=" + key + ", "
        + "priority=" + priority + ", "
        + "alert=" + alert + ", "
        + "fields=" + fields + ", "
        + "groupByFields=" + groupByFields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventDto) {
      EventDto that = (EventDto) o;
      return this.id.equals(that.id())
          && this.eventDefinitionType.equals(that.eventDefinitionType())
          && this.eventDefinitionId.equals(that.eventDefinitionId())
          && this.originContext.equals(that.originContext())
          && this.eventTimestamp.equals(that.eventTimestamp())
          && this.processingTimestamp.equals(that.processingTimestamp())
          && this.timerangeStart.equals(that.timerangeStart())
          && this.timerangeEnd.equals(that.timerangeEnd())
          && this.streams.equals(that.streams())
          && this.sourceStreams.equals(that.sourceStreams())
          && this.message.equals(that.message())
          && this.source.equals(that.source())
          && this.keyTuple.equals(that.keyTuple())
          && (this.key == null ? that.key() == null : this.key.equals(that.key()))
          && this.priority == that.priority()
          && this.alert == that.alert()
          && this.fields.equals(that.fields())
          && this.groupByFields.equals(that.groupByFields());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitionType.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitionId.hashCode();
    h$ *= 1000003;
    h$ ^= originContext.hashCode();
    h$ *= 1000003;
    h$ ^= eventTimestamp.hashCode();
    h$ *= 1000003;
    h$ ^= processingTimestamp.hashCode();
    h$ *= 1000003;
    h$ ^= timerangeStart.hashCode();
    h$ *= 1000003;
    h$ ^= timerangeEnd.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= sourceStreams.hashCode();
    h$ *= 1000003;
    h$ ^= message.hashCode();
    h$ *= 1000003;
    h$ ^= source.hashCode();
    h$ *= 1000003;
    h$ ^= keyTuple.hashCode();
    h$ *= 1000003;
    h$ ^= (key == null) ? 0 : key.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((priority >>> 32) ^ priority);
    h$ *= 1000003;
    h$ ^= alert ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    h$ *= 1000003;
    h$ ^= groupByFields.hashCode();
    return h$;
  }

  @Override
  public EventDto.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventDto.Builder {
    private String id;
    private String eventDefinitionType;
    private String eventDefinitionId;
    private Optional<String> originContext = Optional.empty();
    private DateTime eventTimestamp;
    private DateTime processingTimestamp;
    private Optional<DateTime> timerangeStart = Optional.empty();
    private Optional<DateTime> timerangeEnd = Optional.empty();
    private Set<String> streams;
    private Set<String> sourceStreams;
    private String message;
    private String source;
    private List<String> keyTuple;
    private String key;
    private Long priority;
    private Boolean alert;
    private Map<String, String> fields;
    private Map<String, String> groupByFields;
    Builder() {
    }
    private Builder(EventDto source) {
      this.id = source.id();
      this.eventDefinitionType = source.eventDefinitionType();
      this.eventDefinitionId = source.eventDefinitionId();
      this.originContext = source.originContext();
      this.eventTimestamp = source.eventTimestamp();
      this.processingTimestamp = source.processingTimestamp();
      this.timerangeStart = source.timerangeStart();
      this.timerangeEnd = source.timerangeEnd();
      this.streams = source.streams();
      this.sourceStreams = source.sourceStreams();
      this.message = source.message();
      this.source = source.source();
      this.keyTuple = source.keyTuple();
      this.key = source.key();
      this.priority = source.priority();
      this.alert = source.alert();
      this.fields = source.fields();
      this.groupByFields = source.groupByFields();
    }
    @Override
    public EventDto.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public EventDto.Builder eventDefinitionType(String eventDefinitionType) {
      if (eventDefinitionType == null) {
        throw new NullPointerException("Null eventDefinitionType");
      }
      this.eventDefinitionType = eventDefinitionType;
      return this;
    }
    @Override
    public EventDto.Builder eventDefinitionId(String eventDefinitionId) {
      if (eventDefinitionId == null) {
        throw new NullPointerException("Null eventDefinitionId");
      }
      this.eventDefinitionId = eventDefinitionId;
      return this;
    }
    @Override
    public EventDto.Builder originContext(@Nullable String originContext) {
      this.originContext = Optional.ofNullable(originContext);
      return this;
    }
    @Override
    public EventDto.Builder eventTimestamp(DateTime eventTimestamp) {
      if (eventTimestamp == null) {
        throw new NullPointerException("Null eventTimestamp");
      }
      this.eventTimestamp = eventTimestamp;
      return this;
    }
    @Override
    public EventDto.Builder processingTimestamp(DateTime processingTimestamp) {
      if (processingTimestamp == null) {
        throw new NullPointerException("Null processingTimestamp");
      }
      this.processingTimestamp = processingTimestamp;
      return this;
    }
    @Override
    public EventDto.Builder timerangeStart(@Nullable DateTime timerangeStart) {
      this.timerangeStart = Optional.ofNullable(timerangeStart);
      return this;
    }
    @Override
    public EventDto.Builder timerangeEnd(@Nullable DateTime timerangeEnd) {
      this.timerangeEnd = Optional.ofNullable(timerangeEnd);
      return this;
    }
    @Override
    public EventDto.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public EventDto.Builder sourceStreams(Set<String> sourceStreams) {
      if (sourceStreams == null) {
        throw new NullPointerException("Null sourceStreams");
      }
      this.sourceStreams = sourceStreams;
      return this;
    }
    @Override
    public EventDto.Builder message(String message) {
      if (message == null) {
        throw new NullPointerException("Null message");
      }
      this.message = message;
      return this;
    }
    @Override
    public EventDto.Builder source(String source) {
      if (source == null) {
        throw new NullPointerException("Null source");
      }
      this.source = source;
      return this;
    }
    @Override
    public EventDto.Builder keyTuple(List<String> keyTuple) {
      if (keyTuple == null) {
        throw new NullPointerException("Null keyTuple");
      }
      this.keyTuple = keyTuple;
      return this;
    }
    @Override
    public EventDto.Builder key(@Nullable String key) {
      this.key = key;
      return this;
    }
    @Override
    public EventDto.Builder priority(long priority) {
      this.priority = priority;
      return this;
    }
    @Override
    public EventDto.Builder alert(boolean alert) {
      this.alert = alert;
      return this;
    }
    @Override
    public EventDto.Builder fields(Map<String, String> fields) {
      if (fields == null) {
        throw new NullPointerException("Null fields");
      }
      this.fields = fields;
      return this;
    }
    @Override
    public EventDto.Builder groupByFields(Map<String, String> groupByFields) {
      if (groupByFields == null) {
        throw new NullPointerException("Null groupByFields");
      }
      this.groupByFields = groupByFields;
      return this;
    }
    @Override
    public EventDto build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.eventDefinitionType == null) {
        missing += " eventDefinitionType";
      }
      if (this.eventDefinitionId == null) {
        missing += " eventDefinitionId";
      }
      if (this.eventTimestamp == null) {
        missing += " eventTimestamp";
      }
      if (this.processingTimestamp == null) {
        missing += " processingTimestamp";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.sourceStreams == null) {
        missing += " sourceStreams";
      }
      if (this.message == null) {
        missing += " message";
      }
      if (this.source == null) {
        missing += " source";
      }
      if (this.keyTuple == null) {
        missing += " keyTuple";
      }
      if (this.priority == null) {
        missing += " priority";
      }
      if (this.alert == null) {
        missing += " alert";
      }
      if (this.fields == null) {
        missing += " fields";
      }
      if (this.groupByFields == null) {
        missing += " groupByFields";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventDto(
          this.id,
          this.eventDefinitionType,
          this.eventDefinitionId,
          this.originContext,
          this.eventTimestamp,
          this.processingTimestamp,
          this.timerangeStart,
          this.timerangeEnd,
          this.streams,
          this.sourceStreams,
          this.message,
          this.source,
          this.keyTuple,
          this.key,
          this.priority,
          this.alert,
          this.fields,
          this.groupByFields);
    }
  }

}
