package org.graylog.events.fields;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Generated;
import org.graylog.events.fields.providers.FieldValueProvider;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventFieldSpec extends EventFieldSpec {

  private final FieldValueType dataType;

  private final List<FieldValueProvider.Config> providers;

  private AutoValue_EventFieldSpec(
      FieldValueType dataType,
      List<FieldValueProvider.Config> providers) {
    this.dataType = dataType;
    this.providers = providers;
  }

  @JsonProperty("data_type")
  @Override
  public FieldValueType dataType() {
    return dataType;
  }

  @JsonProperty("providers")
  @Override
  public List<FieldValueProvider.Config> providers() {
    return providers;
  }

  @Override
  public String toString() {
    return "EventFieldSpec{"
        + "dataType=" + dataType + ", "
        + "providers=" + providers
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventFieldSpec) {
      EventFieldSpec that = (EventFieldSpec) o;
      return this.dataType.equals(that.dataType())
          && this.providers.equals(that.providers());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= dataType.hashCode();
    h$ *= 1000003;
    h$ ^= providers.hashCode();
    return h$;
  }

  @Override
  public EventFieldSpec.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventFieldSpec.Builder {
    private FieldValueType dataType;
    private List<FieldValueProvider.Config> providers;
    Builder() {
    }
    private Builder(EventFieldSpec source) {
      this.dataType = source.dataType();
      this.providers = source.providers();
    }
    @Override
    public EventFieldSpec.Builder dataType(FieldValueType dataType) {
      if (dataType == null) {
        throw new NullPointerException("Null dataType");
      }
      this.dataType = dataType;
      return this;
    }
    @Override
    public EventFieldSpec.Builder providers(List<FieldValueProvider.Config> providers) {
      if (providers == null) {
        throw new NullPointerException("Null providers");
      }
      this.providers = providers;
      return this;
    }
    @Override
    public EventFieldSpec build() {
      String missing = "";
      if (this.dataType == null) {
        missing += " dataType";
      }
      if (this.providers == null) {
        missing += " providers";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventFieldSpec(
          this.dataType,
          this.providers);
    }
  }

}
