package org.graylog.events.notifications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventNotificationHandler_Config extends EventNotificationHandler.Config {

  private final String notificationId;

  private final Optional<NotificationParameters> notificationParameters;

  private AutoValue_EventNotificationHandler_Config(
      String notificationId,
      Optional<NotificationParameters> notificationParameters) {
    this.notificationId = notificationId;
    this.notificationParameters = notificationParameters;
  }

  @JsonProperty("notification_id")
  @Override
  public String notificationId() {
    return notificationId;
  }

  @JsonProperty("notification_parameters")
  @Override
  public Optional<NotificationParameters> notificationParameters() {
    return notificationParameters;
  }

  @Override
  public String toString() {
    return "Config{"
        + "notificationId=" + notificationId + ", "
        + "notificationParameters=" + notificationParameters
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventNotificationHandler.Config) {
      EventNotificationHandler.Config that = (EventNotificationHandler.Config) o;
      return this.notificationId.equals(that.notificationId())
          && this.notificationParameters.equals(that.notificationParameters());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= notificationId.hashCode();
    h$ *= 1000003;
    h$ ^= notificationParameters.hashCode();
    return h$;
  }

  @Override
  public EventNotificationHandler.Config.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventNotificationHandler.Config.Builder {
    private String notificationId;
    private Optional<NotificationParameters> notificationParameters = Optional.empty();
    Builder() {
    }
    private Builder(EventNotificationHandler.Config source) {
      this.notificationId = source.notificationId();
      this.notificationParameters = source.notificationParameters();
    }
    @Override
    public EventNotificationHandler.Config.Builder notificationId(String notificationId) {
      if (notificationId == null) {
        throw new NullPointerException("Null notificationId");
      }
      this.notificationId = notificationId;
      return this;
    }
    @Override
    public EventNotificationHandler.Config.Builder notificationParameters(@Nullable NotificationParameters notificationParameters) {
      this.notificationParameters = Optional.ofNullable(notificationParameters);
      return this;
    }
    @Override
    public EventNotificationHandler.Config build() {
      String missing = "";
      if (this.notificationId == null) {
        missing += " notificationId";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventNotificationHandler_Config(
          this.notificationId,
          this.notificationParameters);
    }
  }

}
