package org.graylog.events.notifications;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventNotificationSettings extends EventNotificationSettings {

  private final long gracePeriodMs;

  private final long backlogSize;

  private AutoValue_EventNotificationSettings(
      long gracePeriodMs,
      long backlogSize) {
    this.gracePeriodMs = gracePeriodMs;
    this.backlogSize = backlogSize;
  }

  @JsonProperty("grace_period_ms")
  @Override
  public long gracePeriodMs() {
    return gracePeriodMs;
  }

  @JsonProperty("backlog_size")
  @Override
  public long backlogSize() {
    return backlogSize;
  }

  @Override
  public String toString() {
    return "EventNotificationSettings{"
        + "gracePeriodMs=" + gracePeriodMs + ", "
        + "backlogSize=" + backlogSize
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventNotificationSettings) {
      EventNotificationSettings that = (EventNotificationSettings) o;
      return this.gracePeriodMs == that.gracePeriodMs()
          && this.backlogSize == that.backlogSize();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((gracePeriodMs >>> 32) ^ gracePeriodMs);
    h$ *= 1000003;
    h$ ^= (int) ((backlogSize >>> 32) ^ backlogSize);
    return h$;
  }

  @Override
  public EventNotificationSettings.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventNotificationSettings.Builder {
    private Long gracePeriodMs;
    private Long backlogSize;
    Builder() {
    }
    private Builder(EventNotificationSettings source) {
      this.gracePeriodMs = source.gracePeriodMs();
      this.backlogSize = source.backlogSize();
    }
    @Override
    public EventNotificationSettings.Builder gracePeriodMs(long gracePeriodMs) {
      this.gracePeriodMs = gracePeriodMs;
      return this;
    }
    @Override
    public EventNotificationSettings.Builder backlogSize(long backlogSize) {
      this.backlogSize = backlogSize;
      return this;
    }
    @Override
    public EventNotificationSettings build() {
      String missing = "";
      if (this.gracePeriodMs == null) {
        missing += " gracePeriodMs";
      }
      if (this.backlogSize == null) {
        missing += " backlogSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventNotificationSettings(
          this.gracePeriodMs,
          this.backlogSize);
    }
  }

}
