package org.graylog.events.processor;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventProcessorStateDto extends EventProcessorStateDto {

  private final String id;

  private final String eventDefinitionId;

  private final DateTime minProcessedTimestamp;

  private final DateTime maxProcessedTimestamp;

  private AutoValue_EventProcessorStateDto(
      @Nullable String id,
      String eventDefinitionId,
      DateTime minProcessedTimestamp,
      DateTime maxProcessedTimestamp) {
    this.id = id;
    this.eventDefinitionId = eventDefinitionId;
    this.minProcessedTimestamp = minProcessedTimestamp;
    this.maxProcessedTimestamp = maxProcessedTimestamp;
  }

  @Id
  @ObjectId
  @Nullable
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("event_definition_id")
  @Override
  public String eventDefinitionId() {
    return eventDefinitionId;
  }

  @JsonProperty("min_processed_timestamp")
  @Override
  public DateTime minProcessedTimestamp() {
    return minProcessedTimestamp;
  }

  @JsonProperty("max_processed_timestamp")
  @Override
  public DateTime maxProcessedTimestamp() {
    return maxProcessedTimestamp;
  }

  @Override
  public String toString() {
    return "EventProcessorStateDto{"
        + "id=" + id + ", "
        + "eventDefinitionId=" + eventDefinitionId + ", "
        + "minProcessedTimestamp=" + minProcessedTimestamp + ", "
        + "maxProcessedTimestamp=" + maxProcessedTimestamp
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventProcessorStateDto) {
      EventProcessorStateDto that = (EventProcessorStateDto) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.eventDefinitionId.equals(that.eventDefinitionId())
          && this.minProcessedTimestamp.equals(that.minProcessedTimestamp())
          && this.maxProcessedTimestamp.equals(that.maxProcessedTimestamp());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitionId.hashCode();
    h$ *= 1000003;
    h$ ^= minProcessedTimestamp.hashCode();
    h$ *= 1000003;
    h$ ^= maxProcessedTimestamp.hashCode();
    return h$;
  }

  @Override
  public EventProcessorStateDto.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventProcessorStateDto.Builder {
    private String id;
    private String eventDefinitionId;
    private DateTime minProcessedTimestamp;
    private DateTime maxProcessedTimestamp;
    Builder() {
    }
    private Builder(EventProcessorStateDto source) {
      this.id = source.id();
      this.eventDefinitionId = source.eventDefinitionId();
      this.minProcessedTimestamp = source.minProcessedTimestamp();
      this.maxProcessedTimestamp = source.maxProcessedTimestamp();
    }
    @Override
    public EventProcessorStateDto.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public EventProcessorStateDto.Builder eventDefinitionId(String eventDefinitionId) {
      if (eventDefinitionId == null) {
        throw new NullPointerException("Null eventDefinitionId");
      }
      this.eventDefinitionId = eventDefinitionId;
      return this;
    }
    @Override
    public EventProcessorStateDto.Builder minProcessedTimestamp(DateTime minProcessedTimestamp) {
      if (minProcessedTimestamp == null) {
        throw new NullPointerException("Null minProcessedTimestamp");
      }
      this.minProcessedTimestamp = minProcessedTimestamp;
      return this;
    }
    @Override
    public EventProcessorStateDto.Builder maxProcessedTimestamp(DateTime maxProcessedTimestamp) {
      if (maxProcessedTimestamp == null) {
        throw new NullPointerException("Null maxProcessedTimestamp");
      }
      this.maxProcessedTimestamp = maxProcessedTimestamp;
      return this;
    }
    @Override
    public EventProcessorStateDto build() {
      String missing = "";
      if (this.eventDefinitionId == null) {
        missing += " eventDefinitionId";
      }
      if (this.minProcessedTimestamp == null) {
        missing += " minProcessedTimestamp";
      }
      if (this.maxProcessedTimestamp == null) {
        missing += " maxProcessedTimestamp";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventProcessorStateDto(
          this.id,
          this.eventDefinitionId,
          this.minProcessedTimestamp,
          this.maxProcessedTimestamp);
    }
  }

}
