package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationEventProcessorConfig extends AggregationEventProcessorConfig {

  private final String type;

  private final String query;

  private final ImmutableSet<Parameter> queryParameters;

  private final ImmutableSet<String> streams;

  private final List<String> groupBy;

  private final List<AggregationSeries> series;

  private final Optional<AggregationConditions> conditions;

  private final long searchWithinMs;

  private final long executeEveryMs;

  private AutoValue_AggregationEventProcessorConfig(
      String type,
      String query,
      ImmutableSet<Parameter> queryParameters,
      ImmutableSet<String> streams,
      List<String> groupBy,
      List<AggregationSeries> series,
      Optional<AggregationConditions> conditions,
      long searchWithinMs,
      long executeEveryMs) {
    this.type = type;
    this.query = query;
    this.queryParameters = queryParameters;
    this.streams = streams;
    this.groupBy = groupBy;
    this.series = series;
    this.conditions = conditions;
    this.searchWithinMs = searchWithinMs;
    this.executeEveryMs = executeEveryMs;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("query")
  @Override
  public String query() {
    return query;
  }

  @JsonProperty("query_parameters")
  @Override
  public ImmutableSet<Parameter> queryParameters() {
    return queryParameters;
  }

  @JsonProperty("streams")
  @Override
  public ImmutableSet<String> streams() {
    return streams;
  }

  @JsonProperty("group_by")
  @Override
  public List<String> groupBy() {
    return groupBy;
  }

  @JsonProperty("series")
  @Override
  public List<AggregationSeries> series() {
    return series;
  }

  @JsonProperty("conditions")
  @Override
  public Optional<AggregationConditions> conditions() {
    return conditions;
  }

  @JsonProperty("search_within_ms")
  @Override
  public long searchWithinMs() {
    return searchWithinMs;
  }

  @JsonProperty("execute_every_ms")
  @Override
  public long executeEveryMs() {
    return executeEveryMs;
  }

  @Override
  public String toString() {
    return "AggregationEventProcessorConfig{"
        + "type=" + type + ", "
        + "query=" + query + ", "
        + "queryParameters=" + queryParameters + ", "
        + "streams=" + streams + ", "
        + "groupBy=" + groupBy + ", "
        + "series=" + series + ", "
        + "conditions=" + conditions + ", "
        + "searchWithinMs=" + searchWithinMs + ", "
        + "executeEveryMs=" + executeEveryMs
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationEventProcessorConfig) {
      AggregationEventProcessorConfig that = (AggregationEventProcessorConfig) o;
      return this.type.equals(that.type())
          && this.query.equals(that.query())
          && this.queryParameters.equals(that.queryParameters())
          && this.streams.equals(that.streams())
          && this.groupBy.equals(that.groupBy())
          && this.series.equals(that.series())
          && this.conditions.equals(that.conditions())
          && this.searchWithinMs == that.searchWithinMs()
          && this.executeEveryMs == that.executeEveryMs();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= queryParameters.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= groupBy.hashCode();
    h$ *= 1000003;
    h$ ^= series.hashCode();
    h$ *= 1000003;
    h$ ^= conditions.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((searchWithinMs >>> 32) ^ searchWithinMs);
    h$ *= 1000003;
    h$ ^= (int) ((executeEveryMs >>> 32) ^ executeEveryMs);
    return h$;
  }

  @Override
  public AggregationEventProcessorConfig.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AggregationEventProcessorConfig.Builder {
    private String type;
    private String query;
    private ImmutableSet<Parameter> queryParameters;
    private ImmutableSet<String> streams;
    private List<String> groupBy;
    private List<AggregationSeries> series;
    private Optional<AggregationConditions> conditions = Optional.empty();
    private Long searchWithinMs;
    private Long executeEveryMs;
    Builder() {
    }
    private Builder(AggregationEventProcessorConfig source) {
      this.type = source.type();
      this.query = source.query();
      this.queryParameters = source.queryParameters();
      this.streams = source.streams();
      this.groupBy = source.groupBy();
      this.series = source.series();
      this.conditions = source.conditions();
      this.searchWithinMs = source.searchWithinMs();
      this.executeEveryMs = source.executeEveryMs();
    }
    @Override
    public AggregationEventProcessorConfig.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder query(String query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder queryParameters(Set<Parameter> queryParameters) {
      this.queryParameters = ImmutableSet.copyOf(queryParameters);
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder streams(Set<String> streams) {
      this.streams = ImmutableSet.copyOf(streams);
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder groupBy(List<String> groupBy) {
      if (groupBy == null) {
        throw new NullPointerException("Null groupBy");
      }
      this.groupBy = groupBy;
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder series(List<AggregationSeries> series) {
      if (series == null) {
        throw new NullPointerException("Null series");
      }
      this.series = series;
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder conditions(@Nullable AggregationConditions conditions) {
      this.conditions = Optional.ofNullable(conditions);
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder searchWithinMs(long searchWithinMs) {
      this.searchWithinMs = searchWithinMs;
      return this;
    }
    @Override
    public AggregationEventProcessorConfig.Builder executeEveryMs(long executeEveryMs) {
      this.executeEveryMs = executeEveryMs;
      return this;
    }
    @Override
    public AggregationEventProcessorConfig build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.query == null) {
        missing += " query";
      }
      if (this.queryParameters == null) {
        missing += " queryParameters";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.groupBy == null) {
        missing += " groupBy";
      }
      if (this.series == null) {
        missing += " series";
      }
      if (this.searchWithinMs == null) {
        missing += " searchWithinMs";
      }
      if (this.executeEveryMs == null) {
        missing += " executeEveryMs";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationEventProcessorConfig(
          this.type,
          this.query,
          this.queryParameters,
          this.streams,
          this.groupBy,
          this.series,
          this.conditions,
          this.searchWithinMs,
          this.executeEveryMs);
    }
  }

}
