package org.graylog.events.processor.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationKeyResult extends AggregationKeyResult {

  private final ImmutableList<String> key;

  private final Optional<DateTime> timestamp;

  private final ImmutableList<AggregationSeriesValue> seriesValues;

  private AutoValue_AggregationKeyResult(
      ImmutableList<String> key,
      Optional<DateTime> timestamp,
      ImmutableList<AggregationSeriesValue> seriesValues) {
    this.key = key;
    this.timestamp = timestamp;
    this.seriesValues = seriesValues;
  }

  @Override
  public ImmutableList<String> key() {
    return key;
  }

  @Override
  public Optional<DateTime> timestamp() {
    return timestamp;
  }

  @Override
  public ImmutableList<AggregationSeriesValue> seriesValues() {
    return seriesValues;
  }

  @Override
  public String toString() {
    return "AggregationKeyResult{"
        + "key=" + key + ", "
        + "timestamp=" + timestamp + ", "
        + "seriesValues=" + seriesValues
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationKeyResult) {
      AggregationKeyResult that = (AggregationKeyResult) o;
      return this.key.equals(that.key())
          && this.timestamp.equals(that.timestamp())
          && this.seriesValues.equals(that.seriesValues());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= seriesValues.hashCode();
    return h$;
  }

  @Override
  public AggregationKeyResult.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AggregationKeyResult.Builder {
    private ImmutableList<String> key;
    private Optional<DateTime> timestamp = Optional.empty();
    private ImmutableList<AggregationSeriesValue> seriesValues;
    Builder() {
    }
    private Builder(AggregationKeyResult source) {
      this.key = source.key();
      this.timestamp = source.timestamp();
      this.seriesValues = source.seriesValues();
    }
    @Override
    public AggregationKeyResult.Builder key(List<String> key) {
      this.key = ImmutableList.copyOf(key);
      return this;
    }
    @Override
    public AggregationKeyResult.Builder timestamp(@Nullable DateTime timestamp) {
      this.timestamp = Optional.ofNullable(timestamp);
      return this;
    }
    @Override
    public AggregationKeyResult.Builder seriesValues(List<AggregationSeriesValue> seriesValues) {
      this.seriesValues = ImmutableList.copyOf(seriesValues);
      return this;
    }
    @Override
    public AggregationKeyResult build() {
      String missing = "";
      if (this.key == null) {
        missing += " key";
      }
      if (this.seriesValues == null) {
        missing += " seriesValues";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationKeyResult(
          this.key,
          this.timestamp,
          this.seriesValues);
    }
  }

}
