package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationSeries extends AggregationSeries {

  private final String id;

  private final AggregationFunction function;

  private final Optional<String> field;

  private AutoValue_AggregationSeries(
      String id,
      AggregationFunction function,
      Optional<String> field) {
    this.id = id;
    this.function = function;
    this.field = field;
  }

  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty("function")
  @Override
  public AggregationFunction function() {
    return function;
  }

  @JsonProperty("field")
  @Override
  public Optional<String> field() {
    return field;
  }

  @Override
  public String toString() {
    return "AggregationSeries{"
        + "id=" + id + ", "
        + "function=" + function + ", "
        + "field=" + field
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationSeries) {
      AggregationSeries that = (AggregationSeries) o;
      return this.id.equals(that.id())
          && this.function.equals(that.function())
          && this.field.equals(that.field());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= function.hashCode();
    h$ *= 1000003;
    h$ ^= field.hashCode();
    return h$;
  }

  @Override
  public AggregationSeries.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AggregationSeries.Builder {
    private String id;
    private AggregationFunction function;
    private Optional<String> field = Optional.empty();
    Builder() {
    }
    private Builder(AggregationSeries source) {
      this.id = source.id();
      this.function = source.function();
      this.field = source.field();
    }
    @Override
    public AggregationSeries.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public AggregationSeries.Builder function(AggregationFunction function) {
      if (function == null) {
        throw new NullPointerException("Null function");
      }
      this.function = function;
      return this;
    }
    @Override
    public AggregationSeries.Builder field(@Nullable String field) {
      this.field = Optional.ofNullable(field);
      return this;
    }
    @Override
    Optional<String> field() {
      return field;
    }
    @Override
    AggregationSeries autoBuild() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.function == null) {
        missing += " function";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationSeries(
          this.id,
          this.function,
          this.field);
    }
  }

}
