package org.graylog.events.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventsSearchFilter extends EventsSearchFilter {

  private final EventsSearchFilter.Alerts alerts;

  private final Set<String> eventDefinitions;

  private AutoValue_EventsSearchFilter(
      EventsSearchFilter.Alerts alerts,
      Set<String> eventDefinitions) {
    this.alerts = alerts;
    this.eventDefinitions = eventDefinitions;
  }

  @JsonProperty("alerts")
  @Override
  public EventsSearchFilter.Alerts alerts() {
    return alerts;
  }

  @JsonProperty("event_definitions")
  @Override
  public Set<String> eventDefinitions() {
    return eventDefinitions;
  }

  @Override
  public String toString() {
    return "EventsSearchFilter{"
        + "alerts=" + alerts + ", "
        + "eventDefinitions=" + eventDefinitions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventsSearchFilter) {
      EventsSearchFilter that = (EventsSearchFilter) o;
      return this.alerts.equals(that.alerts())
          && this.eventDefinitions.equals(that.eventDefinitions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= alerts.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitions.hashCode();
    return h$;
  }

  @Override
  public EventsSearchFilter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventsSearchFilter.Builder {
    private EventsSearchFilter.Alerts alerts;
    private Set<String> eventDefinitions;
    Builder() {
    }
    private Builder(EventsSearchFilter source) {
      this.alerts = source.alerts();
      this.eventDefinitions = source.eventDefinitions();
    }
    @Override
    public EventsSearchFilter.Builder alerts(EventsSearchFilter.Alerts alerts) {
      if (alerts == null) {
        throw new NullPointerException("Null alerts");
      }
      this.alerts = alerts;
      return this;
    }
    @Override
    public EventsSearchFilter.Builder eventDefinitions(Set<String> eventDefinitions) {
      if (eventDefinitions == null) {
        throw new NullPointerException("Null eventDefinitions");
      }
      this.eventDefinitions = eventDefinitions;
      return this;
    }
    @Override
    public EventsSearchFilter build() {
      String missing = "";
      if (this.alerts == null) {
        missing += " alerts";
      }
      if (this.eventDefinitions == null) {
        missing += " eventDefinitions";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventsSearchFilter(
          this.alerts,
          this.eventDefinitions);
    }
  }

}
