package org.graylog.events.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventsSearchParameters extends EventsSearchParameters {

  private final int page;

  private final int perPage;

  private final TimeRange timerange;

  private final String query;

  private final EventsSearchFilter filter;

  private final String sortBy;

  private final EventsSearchParameters.SortDirection sortDirection;

  private AutoValue_EventsSearchParameters(
      int page,
      int perPage,
      TimeRange timerange,
      String query,
      EventsSearchFilter filter,
      String sortBy,
      EventsSearchParameters.SortDirection sortDirection) {
    this.page = page;
    this.perPage = perPage;
    this.timerange = timerange;
    this.query = query;
    this.filter = filter;
    this.sortBy = sortBy;
    this.sortDirection = sortDirection;
  }

  @JsonProperty("page")
  @Override
  public int page() {
    return page;
  }

  @JsonProperty("per_page")
  @Override
  public int perPage() {
    return perPage;
  }

  @JsonProperty("timerange")
  @Override
  public TimeRange timerange() {
    return timerange;
  }

  @JsonProperty("query")
  @Override
  public String query() {
    return query;
  }

  @JsonProperty("filter")
  @Override
  public EventsSearchFilter filter() {
    return filter;
  }

  @JsonProperty("sort_by")
  @Override
  public String sortBy() {
    return sortBy;
  }

  @JsonProperty("sort_direction")
  @Override
  public EventsSearchParameters.SortDirection sortDirection() {
    return sortDirection;
  }

  @Override
  public String toString() {
    return "EventsSearchParameters{"
        + "page=" + page + ", "
        + "perPage=" + perPage + ", "
        + "timerange=" + timerange + ", "
        + "query=" + query + ", "
        + "filter=" + filter + ", "
        + "sortBy=" + sortBy + ", "
        + "sortDirection=" + sortDirection
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventsSearchParameters) {
      EventsSearchParameters that = (EventsSearchParameters) o;
      return this.page == that.page()
          && this.perPage == that.perPage()
          && this.timerange.equals(that.timerange())
          && this.query.equals(that.query())
          && this.filter.equals(that.filter())
          && this.sortBy.equals(that.sortBy())
          && this.sortDirection.equals(that.sortDirection());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= page;
    h$ *= 1000003;
    h$ ^= perPage;
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= filter.hashCode();
    h$ *= 1000003;
    h$ ^= sortBy.hashCode();
    h$ *= 1000003;
    h$ ^= sortDirection.hashCode();
    return h$;
  }

  @Override
  public EventsSearchParameters.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventsSearchParameters.Builder {
    private Integer page;
    private Integer perPage;
    private TimeRange timerange;
    private String query;
    private EventsSearchFilter filter;
    private String sortBy;
    private EventsSearchParameters.SortDirection sortDirection;
    Builder() {
    }
    private Builder(EventsSearchParameters source) {
      this.page = source.page();
      this.perPage = source.perPage();
      this.timerange = source.timerange();
      this.query = source.query();
      this.filter = source.filter();
      this.sortBy = source.sortBy();
      this.sortDirection = source.sortDirection();
    }
    @Override
    public EventsSearchParameters.Builder page(int page) {
      this.page = page;
      return this;
    }
    @Override
    public EventsSearchParameters.Builder perPage(int perPage) {
      this.perPage = perPage;
      return this;
    }
    @Override
    public EventsSearchParameters.Builder timerange(TimeRange timerange) {
      if (timerange == null) {
        throw new NullPointerException("Null timerange");
      }
      this.timerange = timerange;
      return this;
    }
    @Override
    public EventsSearchParameters.Builder query(String query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public EventsSearchParameters.Builder filter(EventsSearchFilter filter) {
      if (filter == null) {
        throw new NullPointerException("Null filter");
      }
      this.filter = filter;
      return this;
    }
    @Override
    public EventsSearchParameters.Builder sortBy(String sortBy) {
      if (sortBy == null) {
        throw new NullPointerException("Null sortBy");
      }
      this.sortBy = sortBy;
      return this;
    }
    @Override
    public EventsSearchParameters.Builder sortDirection(EventsSearchParameters.SortDirection sortDirection) {
      if (sortDirection == null) {
        throw new NullPointerException("Null sortDirection");
      }
      this.sortDirection = sortDirection;
      return this;
    }
    @Override
    public EventsSearchParameters build() {
      String missing = "";
      if (this.page == null) {
        missing += " page";
      }
      if (this.perPage == null) {
        missing += " perPage";
      }
      if (this.timerange == null) {
        missing += " timerange";
      }
      if (this.query == null) {
        missing += " query";
      }
      if (this.filter == null) {
        missing += " filter";
      }
      if (this.sortBy == null) {
        missing += " sortBy";
      }
      if (this.sortDirection == null) {
        missing += " sortDirection";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventsSearchParameters(
          this.page,
          this.perPage,
          this.timerange,
          this.query,
          this.filter,
          this.sortBy,
          this.sortDirection);
    }
  }

}
