package org.graylog.freeenterprise;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.validation.constraints.Email;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FreeLicenseAPIRequest extends FreeLicenseAPIRequest {

  private final @NotBlank String clusterId;

  private final @NotBlank String firstName;

  private final @NotBlank String lastName;

  private final @NotBlank @Email String email;

  private final @NotBlank String phone;

  private final @NotBlank String company;

  private final @Min(1L) int version;

  private AutoValue_FreeLicenseAPIRequest(
      @NotBlank String clusterId,
      @NotBlank String firstName,
      @NotBlank String lastName,
      @NotBlank @Email String email,
      @NotBlank String phone,
      @NotBlank String company,
      @Min(1L) int version) {
    this.clusterId = clusterId;
    this.firstName = firstName;
    this.lastName = lastName;
    this.email = email;
    this.phone = phone;
    this.company = company;
    this.version = version;
  }

  @JsonProperty("cluster_id")
  @Override
  public @NotBlank String clusterId() {
    return clusterId;
  }

  @JsonProperty("first_name")
  @Override
  public @NotBlank String firstName() {
    return firstName;
  }

  @JsonProperty("last_name")
  @Override
  public @NotBlank String lastName() {
    return lastName;
  }

  @JsonProperty("email")
  @Override
  public @NotBlank @Email String email() {
    return email;
  }

  @JsonProperty("phone")
  @Override
  public @NotBlank String phone() {
    return phone;
  }

  @JsonProperty("company")
  @Override
  public @NotBlank String company() {
    return company;
  }

  @JsonProperty("version")
  @Override
  public @Min(1L) int version() {
    return version;
  }

  @Override
  public String toString() {
    return "FreeLicenseAPIRequest{"
        + "clusterId=" + clusterId + ", "
        + "firstName=" + firstName + ", "
        + "lastName=" + lastName + ", "
        + "email=" + email + ", "
        + "phone=" + phone + ", "
        + "company=" + company + ", "
        + "version=" + version
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FreeLicenseAPIRequest) {
      FreeLicenseAPIRequest that = (FreeLicenseAPIRequest) o;
      return this.clusterId.equals(that.clusterId())
          && this.firstName.equals(that.firstName())
          && this.lastName.equals(that.lastName())
          && this.email.equals(that.email())
          && this.phone.equals(that.phone())
          && this.company.equals(that.company())
          && this.version == that.version();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= firstName.hashCode();
    h$ *= 1000003;
    h$ ^= lastName.hashCode();
    h$ *= 1000003;
    h$ ^= email.hashCode();
    h$ *= 1000003;
    h$ ^= phone.hashCode();
    h$ *= 1000003;
    h$ ^= company.hashCode();
    h$ *= 1000003;
    h$ ^= version;
    return h$;
  }

  static final class Builder extends FreeLicenseAPIRequest.Builder {
    private @NotBlank String clusterId;
    private @NotBlank String firstName;
    private @NotBlank String lastName;
    private @NotBlank @Email String email;
    private @NotBlank String phone;
    private @NotBlank String company;
    private Integer version;
    Builder() {
    }
    @Override
    public FreeLicenseAPIRequest.Builder clusterId(@NotBlank String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public FreeLicenseAPIRequest.Builder firstName(@NotBlank String firstName) {
      if (firstName == null) {
        throw new NullPointerException("Null firstName");
      }
      this.firstName = firstName;
      return this;
    }
    @Override
    public FreeLicenseAPIRequest.Builder lastName(@NotBlank String lastName) {
      if (lastName == null) {
        throw new NullPointerException("Null lastName");
      }
      this.lastName = lastName;
      return this;
    }
    @Override
    public FreeLicenseAPIRequest.Builder email(@NotBlank @Email String email) {
      if (email == null) {
        throw new NullPointerException("Null email");
      }
      this.email = email;
      return this;
    }
    @Override
    public FreeLicenseAPIRequest.Builder phone(@NotBlank String phone) {
      if (phone == null) {
        throw new NullPointerException("Null phone");
      }
      this.phone = phone;
      return this;
    }
    @Override
    public FreeLicenseAPIRequest.Builder company(@NotBlank String company) {
      if (company == null) {
        throw new NullPointerException("Null company");
      }
      this.company = company;
      return this;
    }
    @Override
    public FreeLicenseAPIRequest.Builder version(int version) {
      this.version = version;
      return this;
    }
    @Override
    public FreeLicenseAPIRequest build() {
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.firstName == null) {
        missing += " firstName";
      }
      if (this.lastName == null) {
        missing += " lastName";
      }
      if (this.email == null) {
        missing += " email";
      }
      if (this.phone == null) {
        missing += " phone";
      }
      if (this.company == null) {
        missing += " company";
      }
      if (this.version == null) {
        missing += " version";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FreeLicenseAPIRequest(
          this.clusterId,
          this.firstName,
          this.lastName,
          this.email,
          this.phone,
          this.company,
          this.version);
    }
  }

}
