package org.graylog.metrics.prometheus.mapping;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PrometheusMappingConfig_MetricMapping extends PrometheusMappingConfig.MetricMapping {

  private final String metricName;

  private final String matchPattern;

  private final ImmutableList<String> wildcardExtractLabels;

  private final ImmutableMap<String, String> additionalLabels;

  private AutoValue_PrometheusMappingConfig_MetricMapping(
      String metricName,
      String matchPattern,
      ImmutableList<String> wildcardExtractLabels,
      ImmutableMap<String, String> additionalLabels) {
    this.metricName = metricName;
    this.matchPattern = matchPattern;
    this.wildcardExtractLabels = wildcardExtractLabels;
    this.additionalLabels = additionalLabels;
  }

  @JsonProperty("metric_name")
  @Override
  public String metricName() {
    return metricName;
  }

  @JsonProperty("match_pattern")
  @Override
  public String matchPattern() {
    return matchPattern;
  }

  @JsonProperty("wildcard_extract_labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public ImmutableList<String> wildcardExtractLabels() {
    return wildcardExtractLabels;
  }

  @JsonProperty("additional_labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public ImmutableMap<String, String> additionalLabels() {
    return additionalLabels;
  }

  @Override
  public String toString() {
    return "MetricMapping{"
        + "metricName=" + metricName + ", "
        + "matchPattern=" + matchPattern + ", "
        + "wildcardExtractLabels=" + wildcardExtractLabels + ", "
        + "additionalLabels=" + additionalLabels
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PrometheusMappingConfig.MetricMapping) {
      PrometheusMappingConfig.MetricMapping that = (PrometheusMappingConfig.MetricMapping) o;
      return this.metricName.equals(that.metricName())
          && this.matchPattern.equals(that.matchPattern())
          && this.wildcardExtractLabels.equals(that.wildcardExtractLabels())
          && this.additionalLabels.equals(that.additionalLabels());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= metricName.hashCode();
    h$ *= 1000003;
    h$ ^= matchPattern.hashCode();
    h$ *= 1000003;
    h$ ^= wildcardExtractLabels.hashCode();
    h$ *= 1000003;
    h$ ^= additionalLabels.hashCode();
    return h$;
  }

  static final class Builder extends PrometheusMappingConfig.MetricMapping.Builder {
    private String metricName;
    private String matchPattern;
    private ImmutableList<String> wildcardExtractLabels;
    private ImmutableMap<String, String> additionalLabels;
    Builder() {
    }
    @Override
    public PrometheusMappingConfig.MetricMapping.Builder metricName(String metricName) {
      if (metricName == null) {
        throw new NullPointerException("Null metricName");
      }
      this.metricName = metricName;
      return this;
    }
    @Override
    public PrometheusMappingConfig.MetricMapping.Builder matchPattern(String matchPattern) {
      if (matchPattern == null) {
        throw new NullPointerException("Null matchPattern");
      }
      this.matchPattern = matchPattern;
      return this;
    }
    @Override
    public PrometheusMappingConfig.MetricMapping.Builder wildcardExtractLabels(List<String> wildcardExtractLabels) {
      this.wildcardExtractLabels = ImmutableList.copyOf(wildcardExtractLabels);
      return this;
    }
    @Override
    public PrometheusMappingConfig.MetricMapping.Builder additionalLabels(Map<String, String> additionalLabels) {
      this.additionalLabels = ImmutableMap.copyOf(additionalLabels);
      return this;
    }
    @Override
    public PrometheusMappingConfig.MetricMapping build() {
      String missing = "";
      if (this.metricName == null) {
        missing += " metricName";
      }
      if (this.matchPattern == null) {
        missing += " matchPattern";
      }
      if (this.wildcardExtractLabels == null) {
        missing += " wildcardExtractLabels";
      }
      if (this.additionalLabels == null) {
        missing += " additionalLabels";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PrometheusMappingConfig_MetricMapping(
          this.metricName,
          this.matchPattern,
          this.wildcardExtractLabels,
          this.additionalLabels);
    }
  }

}
